// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of an Azure Cosmos DB userDefinedFunction. */
@Fluent
public final class SqlUserDefinedFunctionGetProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlUserDefinedFunctionGetProperties.class);

    /*
     * The resource property.
     */
    @JsonProperty(value = "resource")
    private SqlUserDefinedFunctionGetPropertiesResource resource;

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public SqlUserDefinedFunctionGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the SqlUserDefinedFunctionGetProperties object itself.
     */
    public SqlUserDefinedFunctionGetProperties withResource(SqlUserDefinedFunctionGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }
}
