// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties to create and update Azure Cosmos DB storedProcedure. */
@Fluent
public final class SqlStoredProcedureCreateUpdateProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlStoredProcedureCreateUpdateProperties.class);

    /*
     * The standard JSON format of a storedProcedure
     */
    @JsonProperty(value = "resource", required = true)
    private SqlStoredProcedureResource resource;

    /*
     * A key-value pair of options to be applied for the request. This
     * corresponds to the headers sent with the request.
     */
    @JsonProperty(value = "options")
    private CreateUpdateOptions options;

    /**
     * Get the resource property: The standard JSON format of a storedProcedure.
     *
     * @return the resource value.
     */
    public SqlStoredProcedureResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The standard JSON format of a storedProcedure.
     *
     * @param resource the resource value to set.
     * @return the SqlStoredProcedureCreateUpdateProperties object itself.
     */
    public SqlStoredProcedureCreateUpdateProperties withResource(SqlStoredProcedureResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the options property: A key-value pair of options to be applied for the request. This corresponds to the
     * headers sent with the request.
     *
     * @return the options value.
     */
    public CreateUpdateOptions options() {
        return this.options;
    }

    /**
     * Set the options property: A key-value pair of options to be applied for the request. This corresponds to the
     * headers sent with the request.
     *
     * @param options the options value to set.
     * @return the SqlStoredProcedureCreateUpdateProperties object itself.
     */
    public SqlStoredProcedureCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property resource in model SqlStoredProcedureCreateUpdateProperties"));
        } else {
            resource().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }
}
