// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The access keys for the given database account. */
@Immutable
public final class DatabaseAccountListKeysResultInner extends DatabaseAccountListReadOnlyKeysResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DatabaseAccountListKeysResultInner.class);

    /*
     * Base 64 encoded value of the primary read-write key.
     */
    @JsonProperty(value = "primaryMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private String primaryMasterKey;

    /*
     * Base 64 encoded value of the secondary read-write key.
     */
    @JsonProperty(value = "secondaryMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private String secondaryMasterKey;

    /**
     * Get the primaryMasterKey property: Base 64 encoded value of the primary read-write key.
     *
     * @return the primaryMasterKey value.
     */
    public String primaryMasterKey() {
        return this.primaryMasterKey;
    }

    /**
     * Get the secondaryMasterKey property: Base 64 encoded value of the secondary read-write key.
     *
     * @return the secondaryMasterKey value.
     */
    public String secondaryMasterKey() {
        return this.secondaryMasterKey;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
