// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.cosmos.fluent.models.LocationGetResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in LocationsClient. */
public interface LocationsClient {
    /**
     * List Cosmos DB locations and their properties.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains Cosmos DB locations and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<LocationGetResultInner> listAsync();

    /**
     * List Cosmos DB locations and their properties.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains Cosmos DB locations and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LocationGetResultInner> list();

    /**
     * List Cosmos DB locations and their properties.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains Cosmos DB locations and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<LocationGetResultInner> list(Context context);

    /**
     * Get the properties of an existing Cosmos DB location.
     *
     * @param location Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an existing Cosmos DB location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<LocationGetResultInner>> getWithResponseAsync(String location);

    /**
     * Get the properties of an existing Cosmos DB location.
     *
     * @param location Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an existing Cosmos DB location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<LocationGetResultInner> getAsync(String location);

    /**
     * Get the properties of an existing Cosmos DB location.
     *
     * @param location Cosmos DB region, with spaces between words and each word capitalized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an existing Cosmos DB location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    LocationGetResultInner get(String location);

    /**
     * Get the properties of an existing Cosmos DB location.
     *
     * @param location Cosmos DB region, with spaces between words and each word capitalized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of an existing Cosmos DB location.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<LocationGetResultInner> getWithResponse(String location, Context context);
}
