/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.NamespaceProperties;
import java.io.IOException;
import java.util.Map;

public final class ManagedNamespaceInner
extends SubResource {
    private SystemData systemData;
    private Map<String, String> tags;
    private String etag;
    private String location;
    private NamespaceProperties properties;
    private String name;
    private String type;

    public SystemData systemData() {
        return this.systemData;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedNamespaceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String location() {
        return this.location;
    }

    public ManagedNamespaceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public NamespaceProperties properties() {
        return this.properties;
    }

    public ManagedNamespaceInner withProperties(NamespaceProperties properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ManagedNamespaceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedNamespaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedNamespaceInner)((Object)jsonReader.readObject(reader -> {
            ManagedNamespaceInner deserializedManagedNamespaceInner = new ManagedNamespaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedNamespaceInner.withId(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedNamespaceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedManagedNamespaceInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedManagedNamespaceInner.etag = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedNamespaceInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedNamespaceInner.properties = NamespaceProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedNamespaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedNamespaceInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedNamespaceInner;
        }));
    }
}

