/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import java.io.IOException;
import java.util.List;

public final class AgentPoolUpgradeProfileProperties
implements JsonSerializable<AgentPoolUpgradeProfileProperties> {
    private String kubernetesVersion;
    private OSType osType;
    private List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades;
    private String latestNodeImageVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolUpgradeProfileProperties.class);

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public AgentPoolUpgradeProfileProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public OSType osType() {
        return this.osType;
    }

    public AgentPoolUpgradeProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.upgrades;
    }

    public AgentPoolUpgradeProfileProperties withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    public String latestNodeImageVersion() {
        return this.latestNodeImageVersion;
    }

    public AgentPoolUpgradeProfileProperties withLatestNodeImageVersion(String latestNodeImageVersion) {
        this.latestNodeImageVersion = latestNodeImageVersion;
        return this;
    }

    public void validate() {
        if (this.kubernetesVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kubernetesVersion in model AgentPoolUpgradeProfileProperties"));
        }
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model AgentPoolUpgradeProfileProperties"));
        }
        if (this.upgrades() != null) {
            this.upgrades().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("latestNodeImageVersion", this.latestNodeImageVersion);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolUpgradeProfileProperties)jsonReader.readObject(reader -> {
            AgentPoolUpgradeProfileProperties deserializedAgentPoolUpgradeProfileProperties = new AgentPoolUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.osType = OSType.fromString(reader.getString());
                    continue;
                }
                if ("upgrades".equals(fieldName)) {
                    List upgrades;
                    deserializedAgentPoolUpgradeProfileProperties.upgrades = upgrades = reader.readArray(reader1 -> AgentPoolUpgradeProfilePropertiesUpgradesItem.fromJson(reader1));
                    continue;
                }
                if ("latestNodeImageVersion".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileProperties.latestNodeImageVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolUpgradeProfileProperties;
        });
    }
}

