/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AbsoluteMonthlySchedule;
import com.azure.resourcemanager.containerservice.models.DailySchedule;
import com.azure.resourcemanager.containerservice.models.RelativeMonthlySchedule;
import com.azure.resourcemanager.containerservice.models.WeeklySchedule;
import java.io.IOException;

public final class Schedule
implements JsonSerializable<Schedule> {
    private DailySchedule daily;
    private WeeklySchedule weekly;
    private AbsoluteMonthlySchedule absoluteMonthly;
    private RelativeMonthlySchedule relativeMonthly;

    public DailySchedule daily() {
        return this.daily;
    }

    public Schedule withDaily(DailySchedule daily) {
        this.daily = daily;
        return this;
    }

    public WeeklySchedule weekly() {
        return this.weekly;
    }

    public Schedule withWeekly(WeeklySchedule weekly) {
        this.weekly = weekly;
        return this;
    }

    public AbsoluteMonthlySchedule absoluteMonthly() {
        return this.absoluteMonthly;
    }

    public Schedule withAbsoluteMonthly(AbsoluteMonthlySchedule absoluteMonthly) {
        this.absoluteMonthly = absoluteMonthly;
        return this;
    }

    public RelativeMonthlySchedule relativeMonthly() {
        return this.relativeMonthly;
    }

    public Schedule withRelativeMonthly(RelativeMonthlySchedule relativeMonthly) {
        this.relativeMonthly = relativeMonthly;
        return this;
    }

    public void validate() {
        if (this.daily() != null) {
            this.daily().validate();
        }
        if (this.weekly() != null) {
            this.weekly().validate();
        }
        if (this.absoluteMonthly() != null) {
            this.absoluteMonthly().validate();
        }
        if (this.relativeMonthly() != null) {
            this.relativeMonthly().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("daily", (JsonSerializable)this.daily);
        jsonWriter.writeJsonField("weekly", (JsonSerializable)this.weekly);
        jsonWriter.writeJsonField("absoluteMonthly", (JsonSerializable)this.absoluteMonthly);
        jsonWriter.writeJsonField("relativeMonthly", (JsonSerializable)this.relativeMonthly);
        return jsonWriter.writeEndObject();
    }

    public static Schedule fromJson(JsonReader jsonReader) throws IOException {
        return (Schedule)jsonReader.readObject(reader -> {
            Schedule deserializedSchedule = new Schedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("daily".equals(fieldName)) {
                    deserializedSchedule.daily = DailySchedule.fromJson(reader);
                    continue;
                }
                if ("weekly".equals(fieldName)) {
                    deserializedSchedule.weekly = WeeklySchedule.fromJson(reader);
                    continue;
                }
                if ("absoluteMonthly".equals(fieldName)) {
                    deserializedSchedule.absoluteMonthly = AbsoluteMonthlySchedule.fromJson(reader);
                    continue;
                }
                if ("relativeMonthly".equals(fieldName)) {
                    deserializedSchedule.relativeMonthly = RelativeMonthlySchedule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchedule;
        });
    }
}

