/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.LocalDnsForwardDestination;
import com.azure.resourcemanager.containerservice.models.LocalDnsForwardPolicy;
import com.azure.resourcemanager.containerservice.models.LocalDnsProtocol;
import com.azure.resourcemanager.containerservice.models.LocalDnsQueryLogging;
import com.azure.resourcemanager.containerservice.models.LocalDnsServeStale;
import java.io.IOException;

public final class LocalDnsOverride
implements JsonSerializable<LocalDnsOverride> {
    private LocalDnsQueryLogging queryLogging;
    private LocalDnsProtocol protocol;
    private LocalDnsForwardDestination forwardDestination;
    private LocalDnsForwardPolicy forwardPolicy;
    private Integer maxConcurrent;
    private Integer cacheDurationInSeconds;
    private Integer serveStaleDurationInSeconds;
    private LocalDnsServeStale serveStale;

    public LocalDnsQueryLogging queryLogging() {
        return this.queryLogging;
    }

    public LocalDnsOverride withQueryLogging(LocalDnsQueryLogging queryLogging) {
        this.queryLogging = queryLogging;
        return this;
    }

    public LocalDnsProtocol protocol() {
        return this.protocol;
    }

    public LocalDnsOverride withProtocol(LocalDnsProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public LocalDnsForwardDestination forwardDestination() {
        return this.forwardDestination;
    }

    public LocalDnsOverride withForwardDestination(LocalDnsForwardDestination forwardDestination) {
        this.forwardDestination = forwardDestination;
        return this;
    }

    public LocalDnsForwardPolicy forwardPolicy() {
        return this.forwardPolicy;
    }

    public LocalDnsOverride withForwardPolicy(LocalDnsForwardPolicy forwardPolicy) {
        this.forwardPolicy = forwardPolicy;
        return this;
    }

    public Integer maxConcurrent() {
        return this.maxConcurrent;
    }

    public LocalDnsOverride withMaxConcurrent(Integer maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
        return this;
    }

    public Integer cacheDurationInSeconds() {
        return this.cacheDurationInSeconds;
    }

    public LocalDnsOverride withCacheDurationInSeconds(Integer cacheDurationInSeconds) {
        this.cacheDurationInSeconds = cacheDurationInSeconds;
        return this;
    }

    public Integer serveStaleDurationInSeconds() {
        return this.serveStaleDurationInSeconds;
    }

    public LocalDnsOverride withServeStaleDurationInSeconds(Integer serveStaleDurationInSeconds) {
        this.serveStaleDurationInSeconds = serveStaleDurationInSeconds;
        return this;
    }

    public LocalDnsServeStale serveStale() {
        return this.serveStale;
    }

    public LocalDnsOverride withServeStale(LocalDnsServeStale serveStale) {
        this.serveStale = serveStale;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryLogging", this.queryLogging == null ? null : this.queryLogging.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("forwardDestination", this.forwardDestination == null ? null : this.forwardDestination.toString());
        jsonWriter.writeStringField("forwardPolicy", this.forwardPolicy == null ? null : this.forwardPolicy.toString());
        jsonWriter.writeNumberField("maxConcurrent", (Number)this.maxConcurrent);
        jsonWriter.writeNumberField("cacheDurationInSeconds", (Number)this.cacheDurationInSeconds);
        jsonWriter.writeNumberField("serveStaleDurationInSeconds", (Number)this.serveStaleDurationInSeconds);
        jsonWriter.writeStringField("serveStale", this.serveStale == null ? null : this.serveStale.toString());
        return jsonWriter.writeEndObject();
    }

    public static LocalDnsOverride fromJson(JsonReader jsonReader) throws IOException {
        return (LocalDnsOverride)jsonReader.readObject(reader -> {
            LocalDnsOverride deserializedLocalDnsOverride = new LocalDnsOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryLogging".equals(fieldName)) {
                    deserializedLocalDnsOverride.queryLogging = LocalDnsQueryLogging.fromString(reader.getString());
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedLocalDnsOverride.protocol = LocalDnsProtocol.fromString(reader.getString());
                    continue;
                }
                if ("forwardDestination".equals(fieldName)) {
                    deserializedLocalDnsOverride.forwardDestination = LocalDnsForwardDestination.fromString(reader.getString());
                    continue;
                }
                if ("forwardPolicy".equals(fieldName)) {
                    deserializedLocalDnsOverride.forwardPolicy = LocalDnsForwardPolicy.fromString(reader.getString());
                    continue;
                }
                if ("maxConcurrent".equals(fieldName)) {
                    deserializedLocalDnsOverride.maxConcurrent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("cacheDurationInSeconds".equals(fieldName)) {
                    deserializedLocalDnsOverride.cacheDurationInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serveStaleDurationInSeconds".equals(fieldName)) {
                    deserializedLocalDnsOverride.serveStaleDurationInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serveStale".equals(fieldName)) {
                    deserializedLocalDnsOverride.serveStale = LocalDnsServeStale.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalDnsOverride;
        });
    }
}

