// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Determines the type of workload a node can run.
 */
public final class WorkloadRuntime extends ExpandableStringEnum<WorkloadRuntime> {
    /**
     * Static value OCIContainer for WorkloadRuntime.
     */
    public static final WorkloadRuntime OCICONTAINER = fromString("OCIContainer");

    /**
     * Static value WasmWasi for WorkloadRuntime.
     */
    public static final WorkloadRuntime WASM_WASI = fromString("WasmWasi");

    /**
     * Static value KataVmIsolation for WorkloadRuntime.
     */
    public static final WorkloadRuntime KATA_VM_ISOLATION = fromString("KataVmIsolation");

    /**
     * Creates a new instance of WorkloadRuntime value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WorkloadRuntime() {
    }

    /**
     * Creates or finds a WorkloadRuntime from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding WorkloadRuntime.
     */
    public static WorkloadRuntime fromString(String name) {
        return fromString(name, WorkloadRuntime.class);
    }

    /**
     * Gets known WorkloadRuntime values.
     * 
     * @return known WorkloadRuntime values.
     */
    public static Collection<WorkloadRuntime> values() {
        return values(WorkloadRuntime.class);
    }
}
