// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource quota for the namespace.
 */
@Fluent
public final class ResourceQuota implements JsonSerializable<ResourceQuota> {
    /*
     * CPU request of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     */
    private String cpuRequest;

    /*
     * CPU limit of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     */
    private String cpuLimit;

    /*
     * Memory request of the namespace in the power-of-two equivalents form: Ei, Pi, Ti, Gi, Mi, Ki. See [Memory
     * resource units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory)
     * for more details.
     */
    private String memoryRequest;

    /*
     * Memory limit of the namespace in the power-of-two equivalents form: Ei, Pi, Ti, Gi, Mi, Ki. See [Memory resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory) for more
     * details.
     */
    private String memoryLimit;

    /**
     * Creates an instance of ResourceQuota class.
     */
    public ResourceQuota() {
    }

    /**
     * Get the cpuRequest property: CPU request of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     * 
     * @return the cpuRequest value.
     */
    public String cpuRequest() {
        return this.cpuRequest;
    }

    /**
     * Set the cpuRequest property: CPU request of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     * 
     * @param cpuRequest the cpuRequest value to set.
     * @return the ResourceQuota object itself.
     */
    public ResourceQuota withCpuRequest(String cpuRequest) {
        this.cpuRequest = cpuRequest;
        return this;
    }

    /**
     * Get the cpuLimit property: CPU limit of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     * 
     * @return the cpuLimit value.
     */
    public String cpuLimit() {
        return this.cpuLimit;
    }

    /**
     * Set the cpuLimit property: CPU limit of the namespace in one-thousandth CPU form. See [CPU resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu) for more
     * details.
     * 
     * @param cpuLimit the cpuLimit value to set.
     * @return the ResourceQuota object itself.
     */
    public ResourceQuota withCpuLimit(String cpuLimit) {
        this.cpuLimit = cpuLimit;
        return this;
    }

    /**
     * Get the memoryRequest property: Memory request of the namespace in the power-of-two equivalents form: Ei, Pi, Ti,
     * Gi, Mi, Ki. See [Memory resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory) for more
     * details.
     * 
     * @return the memoryRequest value.
     */
    public String memoryRequest() {
        return this.memoryRequest;
    }

    /**
     * Set the memoryRequest property: Memory request of the namespace in the power-of-two equivalents form: Ei, Pi, Ti,
     * Gi, Mi, Ki. See [Memory resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory) for more
     * details.
     * 
     * @param memoryRequest the memoryRequest value to set.
     * @return the ResourceQuota object itself.
     */
    public ResourceQuota withMemoryRequest(String memoryRequest) {
        this.memoryRequest = memoryRequest;
        return this;
    }

    /**
     * Get the memoryLimit property: Memory limit of the namespace in the power-of-two equivalents form: Ei, Pi, Ti, Gi,
     * Mi, Ki. See [Memory resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory) for more
     * details.
     * 
     * @return the memoryLimit value.
     */
    public String memoryLimit() {
        return this.memoryLimit;
    }

    /**
     * Set the memoryLimit property: Memory limit of the namespace in the power-of-two equivalents form: Ei, Pi, Ti, Gi,
     * Mi, Ki. See [Memory resource
     * units](https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory) for more
     * details.
     * 
     * @param memoryLimit the memoryLimit value to set.
     * @return the ResourceQuota object itself.
     */
    public ResourceQuota withMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cpuRequest", this.cpuRequest);
        jsonWriter.writeStringField("cpuLimit", this.cpuLimit);
        jsonWriter.writeStringField("memoryRequest", this.memoryRequest);
        jsonWriter.writeStringField("memoryLimit", this.memoryLimit);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceQuota from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceQuota if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceQuota.
     */
    public static ResourceQuota fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceQuota deserializedResourceQuota = new ResourceQuota();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpuRequest".equals(fieldName)) {
                    deserializedResourceQuota.cpuRequest = reader.getString();
                } else if ("cpuLimit".equals(fieldName)) {
                    deserializedResourceQuota.cpuLimit = reader.getString();
                } else if ("memoryRequest".equals(fieldName)) {
                    deserializedResourceQuota.memoryRequest = reader.getString();
                } else if ("memoryLimit".equals(fieldName)) {
                    deserializedResourceQuota.memoryLimit = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceQuota;
        });
    }
}
