// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enum representing different network policy rules.
 */
public final class PolicyRule extends ExpandableStringEnum<PolicyRule> {
    /**
     * Static value DenyAll for PolicyRule.
     */
    public static final PolicyRule DENY_ALL = fromString("DenyAll");

    /**
     * Static value AllowAll for PolicyRule.
     */
    public static final PolicyRule ALLOW_ALL = fromString("AllowAll");

    /**
     * Static value AllowSameNamespace for PolicyRule.
     */
    public static final PolicyRule ALLOW_SAME_NAMESPACE = fromString("AllowSameNamespace");

    /**
     * Creates a new instance of PolicyRule value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PolicyRule() {
    }

    /**
     * Creates or finds a PolicyRule from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PolicyRule.
     */
    public static PolicyRule fromString(String name) {
        return fromString(name, PolicyRule.class);
    }

    /**
     * Gets known PolicyRule values.
     * 
     * @return known PolicyRule values.
     */
    public static Collection<PolicyRule> values() {
        return values(PolicyRule.class);
    }
}
