// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Default network policy of the namespace, specifying ingress and egress rules.
 */
@Fluent
public final class NetworkPolicies implements JsonSerializable<NetworkPolicies> {
    /*
     * Ingress policy for the network.
     */
    private PolicyRule ingress;

    /*
     * Egress policy for the network.
     */
    private PolicyRule egress;

    /**
     * Creates an instance of NetworkPolicies class.
     */
    public NetworkPolicies() {
    }

    /**
     * Get the ingress property: Ingress policy for the network.
     * 
     * @return the ingress value.
     */
    public PolicyRule ingress() {
        return this.ingress;
    }

    /**
     * Set the ingress property: Ingress policy for the network.
     * 
     * @param ingress the ingress value to set.
     * @return the NetworkPolicies object itself.
     */
    public NetworkPolicies withIngress(PolicyRule ingress) {
        this.ingress = ingress;
        return this;
    }

    /**
     * Get the egress property: Egress policy for the network.
     * 
     * @return the egress value.
     */
    public PolicyRule egress() {
        return this.egress;
    }

    /**
     * Set the egress property: Egress policy for the network.
     * 
     * @param egress the egress value to set.
     * @return the NetworkPolicies object itself.
     */
    public NetworkPolicies withEgress(PolicyRule egress) {
        this.egress = egress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ingress", this.ingress == null ? null : this.ingress.toString());
        jsonWriter.writeStringField("egress", this.egress == null ? null : this.egress.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkPolicies from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkPolicies if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkPolicies.
     */
    public static NetworkPolicies fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkPolicies deserializedNetworkPolicies = new NetworkPolicies();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ingress".equals(fieldName)) {
                    deserializedNetworkPolicies.ingress = PolicyRule.fromString(reader.getString());
                } else if ("egress".equals(fieldName)) {
                    deserializedNetworkPolicies.egress = PolicyRule.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkPolicies;
        });
    }
}
