// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of a namespace managed by ARM.
 */
@Fluent
public final class NamespaceProperties implements JsonSerializable<NamespaceProperties> {
    /*
     * The current provisioning state of the namespace.
     */
    private NamespaceProvisioningState provisioningState;

    /*
     * The labels of managed namespace.
     */
    private Map<String, String> labels;

    /*
     * The annotations of managed namespace.
     */
    private Map<String, String> annotations;

    /*
     * The special FQDN used by the Azure Portal to access the Managed Cluster. This FQDN is for use only by the Azure
     * Portal and should not be used by other clients. The Azure Portal requires certain Cross-Origin Resource Sharing
     * (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special
     * FQDN supports CORS, allowing the Azure Portal to function properly.
     */
    private String portalFqdn;

    /*
     * The default resource quota enforced upon the namespace. Customers can have other Kubernetes resource quota
     * objects under the namespace. Resource quotas are additive; if multiple resource quotas are applied to a given
     * namespace, then the effective limit will be one such that all quotas on the namespace can be satisfied.
     */
    private ResourceQuota defaultResourceQuota;

    /*
     * The default network policy enforced upon the namespace. Customers can have other Kubernetes network policy
     * objects under the namespace. Network policies are additive; if a policy or policies apply to a given pod for a
     * given direction, the connections allowed in that direction for the pod is the union of what all applicable
     * policies allow.
     */
    private NetworkPolicies defaultNetworkPolicy;

    /*
     * Action if Kubernetes namespace with same name already exists.
     */
    private AdoptionPolicy adoptionPolicy;

    /*
     * Delete options of a namespace.
     */
    private DeletePolicy deletePolicy;

    /**
     * Creates an instance of NamespaceProperties class.
     */
    public NamespaceProperties() {
    }

    /**
     * Get the provisioningState property: The current provisioning state of the namespace.
     * 
     * @return the provisioningState value.
     */
    public NamespaceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the labels property: The labels of managed namespace.
     * 
     * @return the labels value.
     */
    public Map<String, String> labels() {
        return this.labels;
    }

    /**
     * Set the labels property: The labels of managed namespace.
     * 
     * @param labels the labels value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    /**
     * Get the annotations property: The annotations of managed namespace.
     * 
     * @return the annotations value.
     */
    public Map<String, String> annotations() {
        return this.annotations;
    }

    /**
     * Set the annotations property: The annotations of managed namespace.
     * 
     * @param annotations the annotations value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    /**
     * Get the portalFqdn property: The special FQDN used by the Azure Portal to access the Managed Cluster. This FQDN
     * is for use only by the Azure Portal and should not be used by other clients. The Azure Portal requires certain
     * Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't
     * handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
     * 
     * @return the portalFqdn value.
     */
    public String portalFqdn() {
        return this.portalFqdn;
    }

    /**
     * Get the defaultResourceQuota property: The default resource quota enforced upon the namespace. Customers can have
     * other Kubernetes resource quota objects under the namespace. Resource quotas are additive; if multiple resource
     * quotas are applied to a given namespace, then the effective limit will be one such that all quotas on the
     * namespace can be satisfied.
     * 
     * @return the defaultResourceQuota value.
     */
    public ResourceQuota defaultResourceQuota() {
        return this.defaultResourceQuota;
    }

    /**
     * Set the defaultResourceQuota property: The default resource quota enforced upon the namespace. Customers can have
     * other Kubernetes resource quota objects under the namespace. Resource quotas are additive; if multiple resource
     * quotas are applied to a given namespace, then the effective limit will be one such that all quotas on the
     * namespace can be satisfied.
     * 
     * @param defaultResourceQuota the defaultResourceQuota value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withDefaultResourceQuota(ResourceQuota defaultResourceQuota) {
        this.defaultResourceQuota = defaultResourceQuota;
        return this;
    }

    /**
     * Get the defaultNetworkPolicy property: The default network policy enforced upon the namespace. Customers can have
     * other Kubernetes network policy objects under the namespace. Network policies are additive; if a policy or
     * policies apply to a given pod for a given direction, the connections allowed in that direction for the pod is the
     * union of what all applicable policies allow.
     * 
     * @return the defaultNetworkPolicy value.
     */
    public NetworkPolicies defaultNetworkPolicy() {
        return this.defaultNetworkPolicy;
    }

    /**
     * Set the defaultNetworkPolicy property: The default network policy enforced upon the namespace. Customers can have
     * other Kubernetes network policy objects under the namespace. Network policies are additive; if a policy or
     * policies apply to a given pod for a given direction, the connections allowed in that direction for the pod is the
     * union of what all applicable policies allow.
     * 
     * @param defaultNetworkPolicy the defaultNetworkPolicy value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withDefaultNetworkPolicy(NetworkPolicies defaultNetworkPolicy) {
        this.defaultNetworkPolicy = defaultNetworkPolicy;
        return this;
    }

    /**
     * Get the adoptionPolicy property: Action if Kubernetes namespace with same name already exists.
     * 
     * @return the adoptionPolicy value.
     */
    public AdoptionPolicy adoptionPolicy() {
        return this.adoptionPolicy;
    }

    /**
     * Set the adoptionPolicy property: Action if Kubernetes namespace with same name already exists.
     * 
     * @param adoptionPolicy the adoptionPolicy value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withAdoptionPolicy(AdoptionPolicy adoptionPolicy) {
        this.adoptionPolicy = adoptionPolicy;
        return this;
    }

    /**
     * Get the deletePolicy property: Delete options of a namespace.
     * 
     * @return the deletePolicy value.
     */
    public DeletePolicy deletePolicy() {
        return this.deletePolicy;
    }

    /**
     * Set the deletePolicy property: Delete options of a namespace.
     * 
     * @param deletePolicy the deletePolicy value to set.
     * @return the NamespaceProperties object itself.
     */
    public NamespaceProperties withDeletePolicy(DeletePolicy deletePolicy) {
        this.deletePolicy = deletePolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defaultResourceQuota() != null) {
            defaultResourceQuota().validate();
        }
        if (defaultNetworkPolicy() != null) {
            defaultNetworkPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("annotations", this.annotations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("defaultResourceQuota", this.defaultResourceQuota);
        jsonWriter.writeJsonField("defaultNetworkPolicy", this.defaultNetworkPolicy);
        jsonWriter.writeStringField("adoptionPolicy",
            this.adoptionPolicy == null ? null : this.adoptionPolicy.toString());
        jsonWriter.writeStringField("deletePolicy", this.deletePolicy == null ? null : this.deletePolicy.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NamespaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NamespaceProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NamespaceProperties.
     */
    public static NamespaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NamespaceProperties deserializedNamespaceProperties = new NamespaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNamespaceProperties.provisioningState
                        = NamespaceProvisioningState.fromString(reader.getString());
                } else if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedNamespaceProperties.labels = labels;
                } else if ("annotations".equals(fieldName)) {
                    Map<String, String> annotations = reader.readMap(reader1 -> reader1.getString());
                    deserializedNamespaceProperties.annotations = annotations;
                } else if ("portalFqdn".equals(fieldName)) {
                    deserializedNamespaceProperties.portalFqdn = reader.getString();
                } else if ("defaultResourceQuota".equals(fieldName)) {
                    deserializedNamespaceProperties.defaultResourceQuota = ResourceQuota.fromJson(reader);
                } else if ("defaultNetworkPolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.defaultNetworkPolicy = NetworkPolicies.fromJson(reader);
                } else if ("adoptionPolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.adoptionPolicy = AdoptionPolicy.fromString(reader.getString());
                } else if ("deletePolicy".equals(fieldName)) {
                    deserializedNamespaceProperties.deletePolicy = DeletePolicy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNamespaceProperties;
        });
    }
}
