// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedNamespaceInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list managed namespaces in a managed cluster.
 */
@Fluent
public final class ManagedNamespaceListResult implements JsonSerializable<ManagedNamespaceListResult> {
    /*
     * The list of managed namespaces.
     */
    private List<ManagedNamespaceInner> value;

    /*
     * The URI to fetch the next page of results, if any.
     */
    private String nextLink;

    /**
     * Creates an instance of ManagedNamespaceListResult class.
     */
    public ManagedNamespaceListResult() {
    }

    /**
     * Get the value property: The list of managed namespaces.
     * 
     * @return the value value.
     */
    public List<ManagedNamespaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of managed namespaces.
     * 
     * @param value the value value to set.
     * @return the ManagedNamespaceListResult object itself.
     */
    public ManagedNamespaceListResult withValue(List<ManagedNamespaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of results, if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of results, if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ManagedNamespaceListResult object itself.
     */
    public ManagedNamespaceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedNamespaceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedNamespaceListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedNamespaceListResult.
     */
    public static ManagedNamespaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedNamespaceListResult deserializedManagedNamespaceListResult = new ManagedNamespaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ManagedNamespaceInner> value
                        = reader.readArray(reader1 -> ManagedNamespaceInner.fromJson(reader1));
                    deserializedManagedNamespaceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedManagedNamespaceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedNamespaceListResult;
        });
    }
}
