// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The tier of a managed cluster SKU. If not specified, the default is 'Free'. See [AKS Pricing
 * Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
 */
public final class ManagedClusterSkuTier extends ExpandableStringEnum<ManagedClusterSkuTier> {
    /**
     * Static value Premium for ManagedClusterSkuTier.
     */
    public static final ManagedClusterSkuTier PREMIUM = fromString("Premium");

    /**
     * Static value Standard for ManagedClusterSkuTier.
     */
    public static final ManagedClusterSkuTier STANDARD = fromString("Standard");

    /**
     * Static value Free for ManagedClusterSkuTier.
     */
    public static final ManagedClusterSkuTier FREE = fromString("Free");

    /**
     * Creates a new instance of ManagedClusterSkuTier value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ManagedClusterSkuTier() {
    }

    /**
     * Creates or finds a ManagedClusterSkuTier from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ManagedClusterSkuTier.
     */
    public static ManagedClusterSkuTier fromString(String name) {
        return fromString(name, ManagedClusterSkuTier.class);
    }

    /**
     * Gets known ManagedClusterSkuTier values.
     * 
     * @return known ManagedClusterSkuTier values.
     */
    public static Collection<ManagedClusterSkuTier> values() {
        return values(ManagedClusterSkuTier.class);
    }
}
