// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enforce TCP or prefer UDP protocol for connections from localDNS to upstream DNS server.
 */
public final class LocalDnsProtocol extends ExpandableStringEnum<LocalDnsProtocol> {
    /**
     * Static value PreferUDP for LocalDnsProtocol.
     */
    public static final LocalDnsProtocol PREFER_UDP = fromString("PreferUDP");

    /**
     * Static value ForceTCP for LocalDnsProtocol.
     */
    public static final LocalDnsProtocol FORCE_TCP = fromString("ForceTCP");

    /**
     * Creates a new instance of LocalDnsProtocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LocalDnsProtocol() {
    }

    /**
     * Creates or finds a LocalDnsProtocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LocalDnsProtocol.
     */
    public static LocalDnsProtocol fromString(String name) {
        return fromString(name, LocalDnsProtocol.class);
    }

    /**
     * Gets known LocalDnsProtocol values.
     * 
     * @return known LocalDnsProtocol values.
     */
    public static Collection<LocalDnsProtocol> values() {
        return values(LocalDnsProtocol.class);
    }
}
