// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Configures the per-node local DNS, with VnetDNS and KubeDNS overrides. LocalDNS helps improve performance and
 * reliability of DNS resolution in an AKS cluster. For more details see aka.ms/aks/localdns.
 */
@Fluent
public final class LocalDnsProfile implements JsonSerializable<LocalDnsProfile> {
    /*
     * Mode of enablement for localDNS.
     */
    private LocalDnsMode mode;

    /*
     * System-generated state of localDNS.
     */
    private LocalDnsState state;

    /*
     * VnetDNS overrides apply to DNS traffic from pods with dnsPolicy:default or kubelet (referred to as VnetDNS
     * traffic).
     */
    private Map<String, LocalDnsOverride> vnetDnsOverrides;

    /*
     * KubeDNS overrides apply to DNS traffic from pods with dnsPolicy:ClusterFirst (referred to as KubeDNS traffic).
     */
    private Map<String, LocalDnsOverride> kubeDnsOverrides;

    /**
     * Creates an instance of LocalDnsProfile class.
     */
    public LocalDnsProfile() {
    }

    /**
     * Get the mode property: Mode of enablement for localDNS.
     * 
     * @return the mode value.
     */
    public LocalDnsMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of enablement for localDNS.
     * 
     * @param mode the mode value to set.
     * @return the LocalDnsProfile object itself.
     */
    public LocalDnsProfile withMode(LocalDnsMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the state property: System-generated state of localDNS.
     * 
     * @return the state value.
     */
    public LocalDnsState state() {
        return this.state;
    }

    /**
     * Get the vnetDnsOverrides property: VnetDNS overrides apply to DNS traffic from pods with dnsPolicy:default or
     * kubelet (referred to as VnetDNS traffic).
     * 
     * @return the vnetDnsOverrides value.
     */
    public Map<String, LocalDnsOverride> vnetDnsOverrides() {
        return this.vnetDnsOverrides;
    }

    /**
     * Set the vnetDnsOverrides property: VnetDNS overrides apply to DNS traffic from pods with dnsPolicy:default or
     * kubelet (referred to as VnetDNS traffic).
     * 
     * @param vnetDnsOverrides the vnetDnsOverrides value to set.
     * @return the LocalDnsProfile object itself.
     */
    public LocalDnsProfile withVnetDnsOverrides(Map<String, LocalDnsOverride> vnetDnsOverrides) {
        this.vnetDnsOverrides = vnetDnsOverrides;
        return this;
    }

    /**
     * Get the kubeDnsOverrides property: KubeDNS overrides apply to DNS traffic from pods with dnsPolicy:ClusterFirst
     * (referred to as KubeDNS traffic).
     * 
     * @return the kubeDnsOverrides value.
     */
    public Map<String, LocalDnsOverride> kubeDnsOverrides() {
        return this.kubeDnsOverrides;
    }

    /**
     * Set the kubeDnsOverrides property: KubeDNS overrides apply to DNS traffic from pods with dnsPolicy:ClusterFirst
     * (referred to as KubeDNS traffic).
     * 
     * @param kubeDnsOverrides the kubeDnsOverrides value to set.
     * @return the LocalDnsProfile object itself.
     */
    public LocalDnsProfile withKubeDnsOverrides(Map<String, LocalDnsOverride> kubeDnsOverrides) {
        this.kubeDnsOverrides = kubeDnsOverrides;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vnetDnsOverrides() != null) {
            vnetDnsOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (kubeDnsOverrides() != null) {
            kubeDnsOverrides().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeMapField("vnetDNSOverrides", this.vnetDnsOverrides,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("kubeDNSOverrides", this.kubeDnsOverrides,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalDnsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalDnsProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalDnsProfile.
     */
    public static LocalDnsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalDnsProfile deserializedLocalDnsProfile = new LocalDnsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedLocalDnsProfile.mode = LocalDnsMode.fromString(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedLocalDnsProfile.state = LocalDnsState.fromString(reader.getString());
                } else if ("vnetDNSOverrides".equals(fieldName)) {
                    Map<String, LocalDnsOverride> vnetDnsOverrides
                        = reader.readMap(reader1 -> LocalDnsOverride.fromJson(reader1));
                    deserializedLocalDnsProfile.vnetDnsOverrides = vnetDnsOverrides;
                } else if ("kubeDNSOverrides".equals(fieldName)) {
                    Map<String, LocalDnsOverride> kubeDnsOverrides
                        = reader.readMap(reader1 -> LocalDnsOverride.fromJson(reader1));
                    deserializedLocalDnsProfile.kubeDnsOverrides = kubeDnsOverrides;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalDnsProfile;
        });
    }
}
