// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Overrides for localDNS profile.
 */
@Fluent
public final class LocalDnsOverride implements JsonSerializable<LocalDnsOverride> {
    /*
     * Log level for DNS queries in localDNS.
     */
    private LocalDnsQueryLogging queryLogging;

    /*
     * Enforce TCP or prefer UDP protocol for connections from localDNS to upstream DNS server.
     */
    private LocalDnsProtocol protocol;

    /*
     * Destination server for DNS queries to be forwarded from localDNS.
     */
    private LocalDnsForwardDestination forwardDestination;

    /*
     * Forward policy for selecting upstream DNS server. See [forward plugin](https://coredns.io/plugins/forward) for
     * more information.
     */
    private LocalDnsForwardPolicy forwardPolicy;

    /*
     * Maximum number of concurrent queries. See [forward plugin](https://coredns.io/plugins/forward) for more
     * information.
     */
    private Integer maxConcurrent;

    /*
     * Cache max TTL in seconds. See [cache plugin](https://coredns.io/plugins/cache) for more information.
     */
    private Integer cacheDurationInSeconds;

    /*
     * Serve stale duration in seconds. See [cache plugin](https://coredns.io/plugins/cache) for more information.
     */
    private Integer serveStaleDurationInSeconds;

    /*
     * Policy for serving stale data. See [cache plugin](https://coredns.io/plugins/cache) for more information.
     */
    private LocalDnsServeStale serveStale;

    /**
     * Creates an instance of LocalDnsOverride class.
     */
    public LocalDnsOverride() {
    }

    /**
     * Get the queryLogging property: Log level for DNS queries in localDNS.
     * 
     * @return the queryLogging value.
     */
    public LocalDnsQueryLogging queryLogging() {
        return this.queryLogging;
    }

    /**
     * Set the queryLogging property: Log level for DNS queries in localDNS.
     * 
     * @param queryLogging the queryLogging value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withQueryLogging(LocalDnsQueryLogging queryLogging) {
        this.queryLogging = queryLogging;
        return this;
    }

    /**
     * Get the protocol property: Enforce TCP or prefer UDP protocol for connections from localDNS to upstream DNS
     * server.
     * 
     * @return the protocol value.
     */
    public LocalDnsProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Enforce TCP or prefer UDP protocol for connections from localDNS to upstream DNS
     * server.
     * 
     * @param protocol the protocol value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withProtocol(LocalDnsProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the forwardDestination property: Destination server for DNS queries to be forwarded from localDNS.
     * 
     * @return the forwardDestination value.
     */
    public LocalDnsForwardDestination forwardDestination() {
        return this.forwardDestination;
    }

    /**
     * Set the forwardDestination property: Destination server for DNS queries to be forwarded from localDNS.
     * 
     * @param forwardDestination the forwardDestination value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withForwardDestination(LocalDnsForwardDestination forwardDestination) {
        this.forwardDestination = forwardDestination;
        return this;
    }

    /**
     * Get the forwardPolicy property: Forward policy for selecting upstream DNS server. See [forward
     * plugin](https://coredns.io/plugins/forward) for more information.
     * 
     * @return the forwardPolicy value.
     */
    public LocalDnsForwardPolicy forwardPolicy() {
        return this.forwardPolicy;
    }

    /**
     * Set the forwardPolicy property: Forward policy for selecting upstream DNS server. See [forward
     * plugin](https://coredns.io/plugins/forward) for more information.
     * 
     * @param forwardPolicy the forwardPolicy value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withForwardPolicy(LocalDnsForwardPolicy forwardPolicy) {
        this.forwardPolicy = forwardPolicy;
        return this;
    }

    /**
     * Get the maxConcurrent property: Maximum number of concurrent queries. See [forward
     * plugin](https://coredns.io/plugins/forward) for more information.
     * 
     * @return the maxConcurrent value.
     */
    public Integer maxConcurrent() {
        return this.maxConcurrent;
    }

    /**
     * Set the maxConcurrent property: Maximum number of concurrent queries. See [forward
     * plugin](https://coredns.io/plugins/forward) for more information.
     * 
     * @param maxConcurrent the maxConcurrent value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withMaxConcurrent(Integer maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
        return this;
    }

    /**
     * Get the cacheDurationInSeconds property: Cache max TTL in seconds. See [cache
     * plugin](https://coredns.io/plugins/cache) for more information.
     * 
     * @return the cacheDurationInSeconds value.
     */
    public Integer cacheDurationInSeconds() {
        return this.cacheDurationInSeconds;
    }

    /**
     * Set the cacheDurationInSeconds property: Cache max TTL in seconds. See [cache
     * plugin](https://coredns.io/plugins/cache) for more information.
     * 
     * @param cacheDurationInSeconds the cacheDurationInSeconds value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withCacheDurationInSeconds(Integer cacheDurationInSeconds) {
        this.cacheDurationInSeconds = cacheDurationInSeconds;
        return this;
    }

    /**
     * Get the serveStaleDurationInSeconds property: Serve stale duration in seconds. See [cache
     * plugin](https://coredns.io/plugins/cache) for more information.
     * 
     * @return the serveStaleDurationInSeconds value.
     */
    public Integer serveStaleDurationInSeconds() {
        return this.serveStaleDurationInSeconds;
    }

    /**
     * Set the serveStaleDurationInSeconds property: Serve stale duration in seconds. See [cache
     * plugin](https://coredns.io/plugins/cache) for more information.
     * 
     * @param serveStaleDurationInSeconds the serveStaleDurationInSeconds value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withServeStaleDurationInSeconds(Integer serveStaleDurationInSeconds) {
        this.serveStaleDurationInSeconds = serveStaleDurationInSeconds;
        return this;
    }

    /**
     * Get the serveStale property: Policy for serving stale data. See [cache plugin](https://coredns.io/plugins/cache)
     * for more information.
     * 
     * @return the serveStale value.
     */
    public LocalDnsServeStale serveStale() {
        return this.serveStale;
    }

    /**
     * Set the serveStale property: Policy for serving stale data. See [cache plugin](https://coredns.io/plugins/cache)
     * for more information.
     * 
     * @param serveStale the serveStale value to set.
     * @return the LocalDnsOverride object itself.
     */
    public LocalDnsOverride withServeStale(LocalDnsServeStale serveStale) {
        this.serveStale = serveStale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryLogging", this.queryLogging == null ? null : this.queryLogging.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("forwardDestination",
            this.forwardDestination == null ? null : this.forwardDestination.toString());
        jsonWriter.writeStringField("forwardPolicy", this.forwardPolicy == null ? null : this.forwardPolicy.toString());
        jsonWriter.writeNumberField("maxConcurrent", this.maxConcurrent);
        jsonWriter.writeNumberField("cacheDurationInSeconds", this.cacheDurationInSeconds);
        jsonWriter.writeNumberField("serveStaleDurationInSeconds", this.serveStaleDurationInSeconds);
        jsonWriter.writeStringField("serveStale", this.serveStale == null ? null : this.serveStale.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalDnsOverride from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalDnsOverride if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocalDnsOverride.
     */
    public static LocalDnsOverride fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalDnsOverride deserializedLocalDnsOverride = new LocalDnsOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queryLogging".equals(fieldName)) {
                    deserializedLocalDnsOverride.queryLogging = LocalDnsQueryLogging.fromString(reader.getString());
                } else if ("protocol".equals(fieldName)) {
                    deserializedLocalDnsOverride.protocol = LocalDnsProtocol.fromString(reader.getString());
                } else if ("forwardDestination".equals(fieldName)) {
                    deserializedLocalDnsOverride.forwardDestination
                        = LocalDnsForwardDestination.fromString(reader.getString());
                } else if ("forwardPolicy".equals(fieldName)) {
                    deserializedLocalDnsOverride.forwardPolicy = LocalDnsForwardPolicy.fromString(reader.getString());
                } else if ("maxConcurrent".equals(fieldName)) {
                    deserializedLocalDnsOverride.maxConcurrent = reader.getNullable(JsonReader::getInt);
                } else if ("cacheDurationInSeconds".equals(fieldName)) {
                    deserializedLocalDnsOverride.cacheDurationInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("serveStaleDurationInSeconds".equals(fieldName)) {
                    deserializedLocalDnsOverride.serveStaleDurationInSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("serveStale".equals(fieldName)) {
                    deserializedLocalDnsOverride.serveStale = LocalDnsServeStale.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalDnsOverride;
        });
    }
}
