// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Mode of enablement for localDNS.
 */
public final class LocalDnsMode extends ExpandableStringEnum<LocalDnsMode> {
    /**
     * Static value Preferred for LocalDnsMode.
     */
    public static final LocalDnsMode PREFERRED = fromString("Preferred");

    /**
     * Static value Required for LocalDnsMode.
     */
    public static final LocalDnsMode REQUIRED = fromString("Required");

    /**
     * Static value Disabled for LocalDnsMode.
     */
    public static final LocalDnsMode DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of LocalDnsMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LocalDnsMode() {
    }

    /**
     * Creates or finds a LocalDnsMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LocalDnsMode.
     */
    public static LocalDnsMode fromString(String name) {
        return fromString(name, LocalDnsMode.class);
    }

    /**
     * Gets known LocalDnsMode values.
     * 
     * @return known LocalDnsMode values.
     */
    public static Collection<LocalDnsMode> values() {
        return values(LocalDnsMode.class);
    }
}
