// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Forward policy for selecting upstream DNS server. See [forward plugin](https://coredns.io/plugins/forward) for more
 * information.
 */
public final class LocalDnsForwardPolicy extends ExpandableStringEnum<LocalDnsForwardPolicy> {
    /**
     * Static value Sequential for LocalDnsForwardPolicy.
     */
    public static final LocalDnsForwardPolicy SEQUENTIAL = fromString("Sequential");

    /**
     * Static value RoundRobin for LocalDnsForwardPolicy.
     */
    public static final LocalDnsForwardPolicy ROUND_ROBIN = fromString("RoundRobin");

    /**
     * Static value Random for LocalDnsForwardPolicy.
     */
    public static final LocalDnsForwardPolicy RANDOM = fromString("Random");

    /**
     * Creates a new instance of LocalDnsForwardPolicy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LocalDnsForwardPolicy() {
    }

    /**
     * Creates or finds a LocalDnsForwardPolicy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LocalDnsForwardPolicy.
     */
    public static LocalDnsForwardPolicy fromString(String name) {
        return fromString(name, LocalDnsForwardPolicy.class);
    }

    /**
     * Gets known LocalDnsForwardPolicy values.
     * 
     * @return known LocalDnsForwardPolicy values.
     */
    public static Collection<LocalDnsForwardPolicy> values() {
        return values(LocalDnsForwardPolicy.class);
    }
}
