// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Destination server for DNS queries to be forwarded from localDNS.
 */
public final class LocalDnsForwardDestination extends ExpandableStringEnum<LocalDnsForwardDestination> {
    /**
     * Static value ClusterCoreDNS for LocalDnsForwardDestination.
     */
    public static final LocalDnsForwardDestination CLUSTER_CORE_DNS = fromString("ClusterCoreDNS");

    /**
     * Static value VnetDNS for LocalDnsForwardDestination.
     */
    public static final LocalDnsForwardDestination VNET_DNS = fromString("VnetDNS");

    /**
     * Creates a new instance of LocalDnsForwardDestination value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LocalDnsForwardDestination() {
    }

    /**
     * Creates or finds a LocalDnsForwardDestination from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LocalDnsForwardDestination.
     */
    public static LocalDnsForwardDestination fromString(String name) {
        return fromString(name, LocalDnsForwardDestination.class);
    }

    /**
     * Gets known LocalDnsForwardDestination values.
     * 
     * @return known LocalDnsForwardDestination values.
     */
    public static Collection<LocalDnsForwardDestination> values() {
        return values(LocalDnsForwardDestination.class);
    }
}
