// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Istio egress gateway configuration.
 */
@Fluent
public final class IstioEgressGateway implements JsonSerializable<IstioEgressGateway> {
    /*
     * Whether to enable the egress gateway.
     */
    private boolean enabled;

    /*
     * Name of the Istio add-on egress gateway.
     */
    private String name;

    /*
     * Namespace that the Istio add-on egress gateway should be deployed in. If unspecified, the default is
     * aks-istio-egress.
     */
    private String namespace;

    /*
     * Name of the gateway configuration custom resource for the Istio add-on egress gateway. Must be specified when
     * enabling the Istio egress gateway. Must be deployed in the same namespace that the Istio egress gateway will be
     * deployed in.
     */
    private String gatewayConfigurationName;

    /**
     * Creates an instance of IstioEgressGateway class.
     */
    public IstioEgressGateway() {
    }

    /**
     * Get the enabled property: Whether to enable the egress gateway.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable the egress gateway.
     * 
     * @param enabled the enabled value to set.
     * @return the IstioEgressGateway object itself.
     */
    public IstioEgressGateway withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the name property: Name of the Istio add-on egress gateway.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Istio add-on egress gateway.
     * 
     * @param name the name value to set.
     * @return the IstioEgressGateway object itself.
     */
    public IstioEgressGateway withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the namespace property: Namespace that the Istio add-on egress gateway should be deployed in. If unspecified,
     * the default is aks-istio-egress.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: Namespace that the Istio add-on egress gateway should be deployed in. If unspecified,
     * the default is aks-istio-egress.
     * 
     * @param namespace the namespace value to set.
     * @return the IstioEgressGateway object itself.
     */
    public IstioEgressGateway withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the gatewayConfigurationName property: Name of the gateway configuration custom resource for the Istio add-on
     * egress gateway. Must be specified when enabling the Istio egress gateway. Must be deployed in the same namespace
     * that the Istio egress gateway will be deployed in.
     * 
     * @return the gatewayConfigurationName value.
     */
    public String gatewayConfigurationName() {
        return this.gatewayConfigurationName;
    }

    /**
     * Set the gatewayConfigurationName property: Name of the gateway configuration custom resource for the Istio add-on
     * egress gateway. Must be specified when enabling the Istio egress gateway. Must be deployed in the same namespace
     * that the Istio egress gateway will be deployed in.
     * 
     * @param gatewayConfigurationName the gatewayConfigurationName value to set.
     * @return the IstioEgressGateway object itself.
     */
    public IstioEgressGateway withGatewayConfigurationName(String gatewayConfigurationName) {
        this.gatewayConfigurationName = gatewayConfigurationName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model IstioEgressGateway"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IstioEgressGateway.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("gatewayConfigurationName", this.gatewayConfigurationName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IstioEgressGateway from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IstioEgressGateway if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IstioEgressGateway.
     */
    public static IstioEgressGateway fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IstioEgressGateway deserializedIstioEgressGateway = new IstioEgressGateway();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedIstioEgressGateway.enabled = reader.getBoolean();
                } else if ("name".equals(fieldName)) {
                    deserializedIstioEgressGateway.name = reader.getString();
                } else if ("namespace".equals(fieldName)) {
                    deserializedIstioEgressGateway.namespace = reader.getString();
                } else if ("gatewayConfigurationName".equals(fieldName)) {
                    deserializedIstioEgressGateway.gatewayConfigurationName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIstioEgressGateway;
        });
    }
}
