// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The security settings of an agent pool.
 */
@Fluent
public final class AgentPoolSecurityProfile implements JsonSerializable<AgentPoolSecurityProfile> {
    /*
     * vTPM is a Trusted Launch feature for configuring a dedicated secure vault for keys and measurements held locally
     * on the node. For more details, see aka.ms/aks/trustedlaunch. If not specified, the default is false.
     */
    private Boolean enableVtpm;

    /*
     * Secure Boot is a feature of Trusted Launch which ensures that only signed operating systems and drivers can boot.
     * For more details, see aka.ms/aks/trustedlaunch. If not specified, the default is false.
     */
    private Boolean enableSecureBoot;

    /*
     * SSH access method of an agent pool.
     */
    private AgentPoolSshAccess sshAccess;

    /**
     * Creates an instance of AgentPoolSecurityProfile class.
     */
    public AgentPoolSecurityProfile() {
    }

    /**
     * Get the enableVtpm property: vTPM is a Trusted Launch feature for configuring a dedicated secure vault for keys
     * and measurements held locally on the node. For more details, see aka.ms/aks/trustedlaunch. If not specified, the
     * default is false.
     * 
     * @return the enableVtpm value.
     */
    public Boolean enableVtpm() {
        return this.enableVtpm;
    }

    /**
     * Set the enableVtpm property: vTPM is a Trusted Launch feature for configuring a dedicated secure vault for keys
     * and measurements held locally on the node. For more details, see aka.ms/aks/trustedlaunch. If not specified, the
     * default is false.
     * 
     * @param enableVtpm the enableVtpm value to set.
     * @return the AgentPoolSecurityProfile object itself.
     */
    public AgentPoolSecurityProfile withEnableVtpm(Boolean enableVtpm) {
        this.enableVtpm = enableVtpm;
        return this;
    }

    /**
     * Get the enableSecureBoot property: Secure Boot is a feature of Trusted Launch which ensures that only signed
     * operating systems and drivers can boot. For more details, see aka.ms/aks/trustedlaunch. If not specified, the
     * default is false.
     * 
     * @return the enableSecureBoot value.
     */
    public Boolean enableSecureBoot() {
        return this.enableSecureBoot;
    }

    /**
     * Set the enableSecureBoot property: Secure Boot is a feature of Trusted Launch which ensures that only signed
     * operating systems and drivers can boot. For more details, see aka.ms/aks/trustedlaunch. If not specified, the
     * default is false.
     * 
     * @param enableSecureBoot the enableSecureBoot value to set.
     * @return the AgentPoolSecurityProfile object itself.
     */
    public AgentPoolSecurityProfile withEnableSecureBoot(Boolean enableSecureBoot) {
        this.enableSecureBoot = enableSecureBoot;
        return this;
    }

    /**
     * Get the sshAccess property: SSH access method of an agent pool.
     * 
     * @return the sshAccess value.
     */
    public AgentPoolSshAccess sshAccess() {
        return this.sshAccess;
    }

    /**
     * Set the sshAccess property: SSH access method of an agent pool.
     * 
     * @param sshAccess the sshAccess value to set.
     * @return the AgentPoolSecurityProfile object itself.
     */
    public AgentPoolSecurityProfile withSshAccess(AgentPoolSshAccess sshAccess) {
        this.sshAccess = sshAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableVTPM", this.enableVtpm);
        jsonWriter.writeBooleanField("enableSecureBoot", this.enableSecureBoot);
        jsonWriter.writeStringField("sshAccess", this.sshAccess == null ? null : this.sshAccess.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolSecurityProfile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolSecurityProfile.
     */
    public static AgentPoolSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolSecurityProfile deserializedAgentPoolSecurityProfile = new AgentPoolSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableVTPM".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.enableVtpm = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableSecureBoot".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.enableSecureBoot = reader.getNullable(JsonReader::getBoolean);
                } else if ("sshAccess".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.sshAccess = AgentPoolSshAccess.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolSecurityProfile;
        });
    }
}
