// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Security profile to enable security features on cilium based cluster.
 */
@Fluent
public final class AdvancedNetworkingSecurity implements JsonSerializable<AdvancedNetworkingSecurity> {
    /*
     * This feature allows user to configure network policy based on DNS (FQDN) names. It can be enabled only on cilium
     * based clusters. If not specified, the default is false.
     */
    private Boolean enabled;

    /*
     * Enable advanced network policies. This allows users to configure Layer 7 network policies (FQDN, HTTP, Kafka).
     * Policies themselves must be configured via the Cilium Network Policy resources, see
     * https://docs.cilium.io/en/latest/security/policy/index.html. This can be enabled only on cilium-based clusters.
     * If not specified, the default value is FQDN if security.enabled is set to true.
     */
    private AdvancedNetworkPolicies advancedNetworkPolicies;

    /**
     * Creates an instance of AdvancedNetworkingSecurity class.
     */
    public AdvancedNetworkingSecurity() {
    }

    /**
     * Get the enabled property: This feature allows user to configure network policy based on DNS (FQDN) names. It can
     * be enabled only on cilium based clusters. If not specified, the default is false.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: This feature allows user to configure network policy based on DNS (FQDN) names. It can
     * be enabled only on cilium based clusters. If not specified, the default is false.
     * 
     * @param enabled the enabled value to set.
     * @return the AdvancedNetworkingSecurity object itself.
     */
    public AdvancedNetworkingSecurity withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the advancedNetworkPolicies property: Enable advanced network policies. This allows users to configure Layer
     * 7 network policies (FQDN, HTTP, Kafka). Policies themselves must be configured via the Cilium Network Policy
     * resources, see https://docs.cilium.io/en/latest/security/policy/index.html. This can be enabled only on
     * cilium-based clusters. If not specified, the default value is FQDN if security.enabled is set to true.
     * 
     * @return the advancedNetworkPolicies value.
     */
    public AdvancedNetworkPolicies advancedNetworkPolicies() {
        return this.advancedNetworkPolicies;
    }

    /**
     * Set the advancedNetworkPolicies property: Enable advanced network policies. This allows users to configure Layer
     * 7 network policies (FQDN, HTTP, Kafka). Policies themselves must be configured via the Cilium Network Policy
     * resources, see https://docs.cilium.io/en/latest/security/policy/index.html. This can be enabled only on
     * cilium-based clusters. If not specified, the default value is FQDN if security.enabled is set to true.
     * 
     * @param advancedNetworkPolicies the advancedNetworkPolicies value to set.
     * @return the AdvancedNetworkingSecurity object itself.
     */
    public AdvancedNetworkingSecurity withAdvancedNetworkPolicies(AdvancedNetworkPolicies advancedNetworkPolicies) {
        this.advancedNetworkPolicies = advancedNetworkPolicies;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("advancedNetworkPolicies",
            this.advancedNetworkPolicies == null ? null : this.advancedNetworkPolicies.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdvancedNetworkingSecurity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdvancedNetworkingSecurity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AdvancedNetworkingSecurity.
     */
    public static AdvancedNetworkingSecurity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdvancedNetworkingSecurity deserializedAdvancedNetworkingSecurity = new AdvancedNetworkingSecurity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedAdvancedNetworkingSecurity.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("advancedNetworkPolicies".equals(fieldName)) {
                    deserializedAdvancedNetworkingSecurity.advancedNetworkPolicies
                        = AdvancedNetworkPolicies.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdvancedNetworkingSecurity;
        });
    }
}
