// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.OrchestratorVersionProfile;
import java.io.IOException;
import java.util.List;

/**
 * The properties of an orchestrator version profile.
 */
@Fluent
public final class OrchestratorVersionProfileProperties
    implements JsonSerializable<OrchestratorVersionProfileProperties> {
    /*
     * List of orchestrator version profiles.
     */
    private List<OrchestratorVersionProfile> orchestrators;

    /**
     * Creates an instance of OrchestratorVersionProfileProperties class.
     */
    public OrchestratorVersionProfileProperties() {
    }

    /**
     * Get the orchestrators property: List of orchestrator version profiles.
     * 
     * @return the orchestrators value.
     */
    public List<OrchestratorVersionProfile> orchestrators() {
        return this.orchestrators;
    }

    /**
     * Set the orchestrators property: List of orchestrator version profiles.
     * 
     * @param orchestrators the orchestrators value to set.
     * @return the OrchestratorVersionProfileProperties object itself.
     */
    public OrchestratorVersionProfileProperties withOrchestrators(List<OrchestratorVersionProfile> orchestrators) {
        this.orchestrators = orchestrators;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (orchestrators() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property orchestrators in model OrchestratorVersionProfileProperties"));
        } else {
            orchestrators().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorVersionProfileProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("orchestrators", this.orchestrators, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrchestratorVersionProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrchestratorVersionProfileProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OrchestratorVersionProfileProperties.
     */
    public static OrchestratorVersionProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestratorVersionProfileProperties deserializedOrchestratorVersionProfileProperties
                = new OrchestratorVersionProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("orchestrators".equals(fieldName)) {
                    List<OrchestratorVersionProfile> orchestrators
                        = reader.readArray(reader1 -> OrchestratorVersionProfile.fromJson(reader1));
                    deserializedOrchestratorVersionProfileProperties.orchestrators = orchestrators;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrchestratorVersionProfileProperties;
        });
    }
}
