// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a Operation value.
 */
@Immutable
public final class OperationValueInner implements JsonSerializable<OperationValueInner> {
    /*
     * The origin of the operation.
     */
    private String origin;

    /*
     * The name of the operation.
     */
    private String name;

    /*
     * Describes the properties of a Operation Value Display.
     */
    private OperationValueDisplay innerDisplay;

    /**
     * Creates an instance of OperationValueInner class.
     */
    public OperationValueInner() {
    }

    /**
     * Get the origin property: The origin of the operation.
     * 
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Get the name property: The name of the operation.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the innerDisplay property: Describes the properties of a Operation Value Display.
     * 
     * @return the innerDisplay value.
     */
    private OperationValueDisplay innerDisplay() {
        return this.innerDisplay;
    }

    /**
     * Get the operation property: The display name of the operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.innerDisplay() == null ? null : this.innerDisplay().operation();
    }

    /**
     * Get the resource property: The display name of the resource the operation applies to.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.innerDisplay() == null ? null : this.innerDisplay().resource();
    }

    /**
     * Get the description property: The description of the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerDisplay() == null ? null : this.innerDisplay().description();
    }

    /**
     * Get the provider property: The resource provider for the operation.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerDisplay() == null ? null : this.innerDisplay().provider();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerDisplay() != null) {
            innerDisplay().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("display", this.innerDisplay);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationValueInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationValueInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationValueInner.
     */
    public static OperationValueInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationValueInner deserializedOperationValueInner = new OperationValueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("origin".equals(fieldName)) {
                    deserializedOperationValueInner.origin = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedOperationValueInner.name = reader.getString();
                } else if ("display".equals(fieldName)) {
                    deserializedOperationValueInner.innerDisplay = OperationValueDisplay.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationValueInner;
        });
    }
}
