// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.NamespaceProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Namespace managed by ARM.
 */
@Fluent
public final class ManagedNamespaceInner extends SubResource {
    /*
     * The system metadata relating to this resource.
     */
    private SystemData systemData;

    /*
     * The tags to be persisted on the managed cluster namespace.
     */
    private Map<String, String> tags;

    /*
     * Unique read-only string used to implement optimistic concurrency. The eTag value will change when the resource is
     * updated. Specify an if-match or if-none-match header with the eTag value for a subsequent request to enable
     * optimistic concurrency per the normal eTag convention.
     */
    private String etag;

    /*
     * The location of the namespace.
     */
    private String location;

    /*
     * Properties of a namespace.
     */
    private NamespaceProperties properties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /**
     * Creates an instance of ManagedNamespaceInner class.
     */
    public ManagedNamespaceInner() {
    }

    /**
     * Get the systemData property: The system metadata relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the tags property: The tags to be persisted on the managed cluster namespace.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags to be persisted on the managed cluster namespace.
     * 
     * @param tags the tags value to set.
     * @return the ManagedNamespaceInner object itself.
     */
    public ManagedNamespaceInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the etag property: Unique read-only string used to implement optimistic concurrency. The eTag value will
     * change when the resource is updated. Specify an if-match or if-none-match header with the eTag value for a
     * subsequent request to enable optimistic concurrency per the normal eTag convention.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the location property: The location of the namespace.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the namespace.
     * 
     * @param location the location value to set.
     * @return the ManagedNamespaceInner object itself.
     */
    public ManagedNamespaceInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the properties property: Properties of a namespace.
     * 
     * @return the properties value.
     */
    public NamespaceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a namespace.
     * 
     * @param properties the properties value to set.
     * @return the ManagedNamespaceInner object itself.
     */
    public ManagedNamespaceInner withProperties(NamespaceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedNamespaceInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedNamespaceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedNamespaceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedNamespaceInner.
     */
    public static ManagedNamespaceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedNamespaceInner deserializedManagedNamespaceInner = new ManagedNamespaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedNamespaceInner.withId(reader.getString());
                } else if ("systemData".equals(fieldName)) {
                    deserializedManagedNamespaceInner.systemData = SystemData.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedNamespaceInner.tags = tags;
                } else if ("eTag".equals(fieldName)) {
                    deserializedManagedNamespaceInner.etag = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedNamespaceInner.location = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedNamespaceInner.properties = NamespaceProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedManagedNamespaceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedNamespaceInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedNamespaceInner;
        });
    }
}
