// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerservice.fluent.models.CredentialResultsInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedNamespaceInner;
import com.azure.resourcemanager.containerservice.models.TagsObject;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ManagedNamespacesClient.
 */
public interface ManagedNamespacesClient {
    /**
     * Gets a list of managed namespaces in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed namespaces in the specified managed cluster as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedNamespaceInner> listByManagedClusterAsync(String resourceGroupName, String resourceName);

    /**
     * Gets a list of managed namespaces in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed namespaces in the specified managed cluster as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedNamespaceInner> listByManagedCluster(String resourceGroupName, String resourceName);

    /**
     * Gets a list of managed namespaces in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed namespaces in the specified managed cluster as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedNamespaceInner> listByManagedCluster(String resourceGroupName, String resourceName,
        Context context);

    /**
     * Gets the specified namespace of a managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified namespace of a managed cluster along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedNamespaceInner>> getWithResponseAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName);

    /**
     * Gets the specified namespace of a managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified namespace of a managed cluster on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedNamespaceInner> getAsync(String resourceGroupName, String resourceName, String managedNamespaceName);

    /**
     * Gets the specified namespace of a managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified namespace of a managed cluster along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedNamespaceInner> getWithResponse(String resourceGroupName, String resourceName,
        String managedNamespaceName, Context context);

    /**
     * Gets the specified namespace of a managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified namespace of a managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedNamespaceInner get(String resourceGroupName, String resourceName, String managedNamespaceName);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName, ManagedNamespaceInner parameters);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ManagedNamespaceInner>, ManagedNamespaceInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String resourceName, String managedNamespaceName, ManagedNamespaceInner parameters);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedNamespaceInner>, ManagedNamespaceInner> beginCreateOrUpdate(String resourceGroupName,
        String resourceName, String managedNamespaceName, ManagedNamespaceInner parameters);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ManagedNamespaceInner>, ManagedNamespaceInner> beginCreateOrUpdate(String resourceGroupName,
        String resourceName, String managedNamespaceName, ManagedNamespaceInner parameters, Context context);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedNamespaceInner> createOrUpdateAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName, ManagedNamespaceInner parameters);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedNamespaceInner createOrUpdate(String resourceGroupName, String resourceName, String managedNamespaceName,
        ManagedNamespaceInner parameters);

    /**
     * Creates or updates a namespace managed by ARM for the specified managed cluster. Users can configure aspects like
     * resource quotas, network ingress/egress policies, and more. See aka.ms/aks/managed-namespaces for more details.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters The namespace to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedNamespaceInner createOrUpdate(String resourceGroupName, String resourceName, String managedNamespaceName,
        ManagedNamespaceInner parameters, Context context);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String managedNamespaceName);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String managedNamespaceName, Context context);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String managedNamespaceName);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, String managedNamespaceName);

    /**
     * Deletes a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, String managedNamespaceName, Context context);

    /**
     * Updates tags on a managed namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters Parameters supplied to the patch namespace operation, we only support patch tags for now.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedNamespaceInner>> updateWithResponseAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName, TagsObject parameters);

    /**
     * Updates tags on a managed namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters Parameters supplied to the patch namespace operation, we only support patch tags for now.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedNamespaceInner> updateAsync(String resourceGroupName, String resourceName, String managedNamespaceName,
        TagsObject parameters);

    /**
     * Updates tags on a managed namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters Parameters supplied to the patch namespace operation, we only support patch tags for now.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedNamespaceInner> updateWithResponse(String resourceGroupName, String resourceName,
        String managedNamespaceName, TagsObject parameters, Context context);

    /**
     * Updates tags on a managed namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param parameters Parameters supplied to the patch namespace operation, we only support patch tags for now.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return namespace managed by ARM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedNamespaceInner update(String resourceGroupName, String resourceName, String managedNamespaceName,
        TagsObject parameters);

    /**
     * Lists the credentials of a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list credential result response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CredentialResultsInner>> listCredentialWithResponseAsync(String resourceGroupName,
        String resourceName, String managedNamespaceName);

    /**
     * Lists the credentials of a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list credential result response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CredentialResultsInner> listCredentialAsync(String resourceGroupName, String resourceName,
        String managedNamespaceName);

    /**
     * Lists the credentials of a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list credential result response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CredentialResultsInner> listCredentialWithResponse(String resourceGroupName, String resourceName,
        String managedNamespaceName, Context context);

    /**
     * Lists the credentials of a namespace.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param managedNamespaceName The name of the managed namespace.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list credential result response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CredentialResultsInner listCredential(String resourceGroupName, String resourceName, String managedNamespaceName);
}
