/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolSshAccess;
import java.io.IOException;

public final class AgentPoolSecurityProfile
implements JsonSerializable<AgentPoolSecurityProfile> {
    private Boolean enableVtpm;
    private Boolean enableSecureBoot;
    private AgentPoolSshAccess sshAccess;

    public Boolean enableVtpm() {
        return this.enableVtpm;
    }

    public AgentPoolSecurityProfile withEnableVtpm(Boolean enableVtpm) {
        this.enableVtpm = enableVtpm;
        return this;
    }

    public Boolean enableSecureBoot() {
        return this.enableSecureBoot;
    }

    public AgentPoolSecurityProfile withEnableSecureBoot(Boolean enableSecureBoot) {
        this.enableSecureBoot = enableSecureBoot;
        return this;
    }

    public AgentPoolSshAccess sshAccess() {
        return this.sshAccess;
    }

    public AgentPoolSecurityProfile withSshAccess(AgentPoolSshAccess sshAccess) {
        this.sshAccess = sshAccess;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableVTPM", this.enableVtpm);
        jsonWriter.writeBooleanField("enableSecureBoot", this.enableSecureBoot);
        jsonWriter.writeStringField("sshAccess", this.sshAccess == null ? null : this.sshAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolSecurityProfile)jsonReader.readObject(reader -> {
            AgentPoolSecurityProfile deserializedAgentPoolSecurityProfile = new AgentPoolSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableVTPM".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.enableVtpm = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableSecureBoot".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.enableSecureBoot = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sshAccess".equals(fieldName)) {
                    deserializedAgentPoolSecurityProfile.sshAccess = AgentPoolSshAccess.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolSecurityProfile;
        });
    }
}

