// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifications on VirtualMachines agent pool.
 */
@Fluent
public final class VirtualMachinesProfile implements JsonSerializable<VirtualMachinesProfile> {
    /*
     * Specifications on how to scale a VirtualMachines agent pool.
     */
    private ScaleProfile scale;

    /**
     * Creates an instance of VirtualMachinesProfile class.
     */
    public VirtualMachinesProfile() {
    }

    /**
     * Get the scale property: Specifications on how to scale a VirtualMachines agent pool.
     * 
     * @return the scale value.
     */
    public ScaleProfile scale() {
        return this.scale;
    }

    /**
     * Set the scale property: Specifications on how to scale a VirtualMachines agent pool.
     * 
     * @param scale the scale value to set.
     * @return the VirtualMachinesProfile object itself.
     */
    public VirtualMachinesProfile withScale(ScaleProfile scale) {
        this.scale = scale;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scale() != null) {
            scale().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scale", this.scale);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachinesProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachinesProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachinesProfile.
     */
    public static VirtualMachinesProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachinesProfile deserializedVirtualMachinesProfile = new VirtualMachinesProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scale".equals(fieldName)) {
                    deserializedVirtualMachinesProfile.scale = ScaleProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachinesProfile;
        });
    }
}
