// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ManagedClusterNodeProvisioningProfile model.
 */
@Fluent
public final class ManagedClusterNodeProvisioningProfile
    implements JsonSerializable<ManagedClusterNodeProvisioningProfile> {
    /*
     * The node provisioning mode. If not specified, the default is Manual.
     */
    private NodeProvisioningMode mode;

    /*
     * The set of default Karpenter NodePools (CRDs) configured for node provisioning. This field has no effect unless
     * mode is 'Auto'. Warning: Changing this from Auto to None on an existing cluster will cause the default Karpenter
     * NodePools to be deleted, which will drain and delete the nodes associated with those pools. It is strongly
     * recommended to not do this unless there are idle nodes ready to take the pods evicted by that action. If not
     * specified, the default is Auto. For more information see aka.ms/aks/nap#node-pools.
     */
    private NodeProvisioningDefaultNodePools defaultNodePools;

    /**
     * Creates an instance of ManagedClusterNodeProvisioningProfile class.
     */
    public ManagedClusterNodeProvisioningProfile() {
    }

    /**
     * Get the mode property: The node provisioning mode. If not specified, the default is Manual.
     * 
     * @return the mode value.
     */
    public NodeProvisioningMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The node provisioning mode. If not specified, the default is Manual.
     * 
     * @param mode the mode value to set.
     * @return the ManagedClusterNodeProvisioningProfile object itself.
     */
    public ManagedClusterNodeProvisioningProfile withMode(NodeProvisioningMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the defaultNodePools property: The set of default Karpenter NodePools (CRDs) configured for node
     * provisioning. This field has no effect unless mode is 'Auto'. Warning: Changing this from Auto to None on an
     * existing cluster will cause the default Karpenter NodePools to be deleted, which will drain and delete the nodes
     * associated with those pools. It is strongly recommended to not do this unless there are idle nodes ready to take
     * the pods evicted by that action. If not specified, the default is Auto. For more information see
     * aka.ms/aks/nap#node-pools.
     * 
     * @return the defaultNodePools value.
     */
    public NodeProvisioningDefaultNodePools defaultNodePools() {
        return this.defaultNodePools;
    }

    /**
     * Set the defaultNodePools property: The set of default Karpenter NodePools (CRDs) configured for node
     * provisioning. This field has no effect unless mode is 'Auto'. Warning: Changing this from Auto to None on an
     * existing cluster will cause the default Karpenter NodePools to be deleted, which will drain and delete the nodes
     * associated with those pools. It is strongly recommended to not do this unless there are idle nodes ready to take
     * the pods evicted by that action. If not specified, the default is Auto. For more information see
     * aka.ms/aks/nap#node-pools.
     * 
     * @param defaultNodePools the defaultNodePools value to set.
     * @return the ManagedClusterNodeProvisioningProfile object itself.
     */
    public ManagedClusterNodeProvisioningProfile
        withDefaultNodePools(NodeProvisioningDefaultNodePools defaultNodePools) {
        this.defaultNodePools = defaultNodePools;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("defaultNodePools",
            this.defaultNodePools == null ? null : this.defaultNodePools.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterNodeProvisioningProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterNodeProvisioningProfile if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterNodeProvisioningProfile.
     */
    public static ManagedClusterNodeProvisioningProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterNodeProvisioningProfile deserializedManagedClusterNodeProvisioningProfile
                = new ManagedClusterNodeProvisioningProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedManagedClusterNodeProvisioningProfile.mode
                        = NodeProvisioningMode.fromString(reader.getString());
                } else if ("defaultNodePools".equals(fieldName)) {
                    deserializedManagedClusterNodeProvisioningProfile.defaultNodePools
                        = NodeProvisioningDefaultNodePools.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterNodeProvisioningProfile;
        });
    }
}
