// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The bootstrap profile.
 */
@Fluent
public final class ManagedClusterBootstrapProfile implements JsonSerializable<ManagedClusterBootstrapProfile> {
    /*
     * The artifact source. The source where the artifacts are downloaded from.
     */
    private ArtifactSource artifactSource;

    /*
     * The resource Id of Azure Container Registry. The registry must have private network access, premium SKU and zone
     * redundancy.
     */
    private String containerRegistryId;

    /**
     * Creates an instance of ManagedClusterBootstrapProfile class.
     */
    public ManagedClusterBootstrapProfile() {
    }

    /**
     * Get the artifactSource property: The artifact source. The source where the artifacts are downloaded from.
     * 
     * @return the artifactSource value.
     */
    public ArtifactSource artifactSource() {
        return this.artifactSource;
    }

    /**
     * Set the artifactSource property: The artifact source. The source where the artifacts are downloaded from.
     * 
     * @param artifactSource the artifactSource value to set.
     * @return the ManagedClusterBootstrapProfile object itself.
     */
    public ManagedClusterBootstrapProfile withArtifactSource(ArtifactSource artifactSource) {
        this.artifactSource = artifactSource;
        return this;
    }

    /**
     * Get the containerRegistryId property: The resource Id of Azure Container Registry. The registry must have private
     * network access, premium SKU and zone redundancy.
     * 
     * @return the containerRegistryId value.
     */
    public String containerRegistryId() {
        return this.containerRegistryId;
    }

    /**
     * Set the containerRegistryId property: The resource Id of Azure Container Registry. The registry must have private
     * network access, premium SKU and zone redundancy.
     * 
     * @param containerRegistryId the containerRegistryId value to set.
     * @return the ManagedClusterBootstrapProfile object itself.
     */
    public ManagedClusterBootstrapProfile withContainerRegistryId(String containerRegistryId) {
        this.containerRegistryId = containerRegistryId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("artifactSource",
            this.artifactSource == null ? null : this.artifactSource.toString());
        jsonWriter.writeStringField("containerRegistryId", this.containerRegistryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterBootstrapProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterBootstrapProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterBootstrapProfile.
     */
    public static ManagedClusterBootstrapProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterBootstrapProfile deserializedManagedClusterBootstrapProfile
                = new ManagedClusterBootstrapProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("artifactSource".equals(fieldName)) {
                    deserializedManagedClusterBootstrapProfile.artifactSource
                        = ArtifactSource.fromString(reader.getString());
                } else if ("containerRegistryId".equals(fieldName)) {
                    deserializedManagedClusterBootstrapProfile.containerRegistryId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterBootstrapProfile;
        });
    }
}
