// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * For schedules like: 'recur every day' or 'recur every 3 days'.
 */
@Fluent
public final class DailySchedule implements JsonSerializable<DailySchedule> {
    /*
     * Specifies the number of days between each set of occurrences.
     */
    private int intervalDays;

    /**
     * Creates an instance of DailySchedule class.
     */
    public DailySchedule() {
    }

    /**
     * Get the intervalDays property: Specifies the number of days between each set of occurrences.
     * 
     * @return the intervalDays value.
     */
    public int intervalDays() {
        return this.intervalDays;
    }

    /**
     * Set the intervalDays property: Specifies the number of days between each set of occurrences.
     * 
     * @param intervalDays the intervalDays value to set.
     * @return the DailySchedule object itself.
     */
    public DailySchedule withIntervalDays(int intervalDays) {
        this.intervalDays = intervalDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("intervalDays", this.intervalDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DailySchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DailySchedule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DailySchedule.
     */
    public static DailySchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DailySchedule deserializedDailySchedule = new DailySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("intervalDays".equals(fieldName)) {
                    deserializedDailySchedule.intervalDays = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDailySchedule;
        });
    }
}
