// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enable advanced network policies. This allows users to configure Layer 7 network policies (FQDN, HTTP, Kafka).
 * Policies themselves must be configured via the Cilium Network Policy resources, see
 * https://docs.cilium.io/en/latest/security/policy/index.html. This can be enabled only on cilium-based clusters. If
 * not specified, the default value is FQDN if security.enabled is set to true.
 */
public final class AdvancedNetworkPolicies extends ExpandableStringEnum<AdvancedNetworkPolicies> {
    /**
     * Static value L7 for AdvancedNetworkPolicies.
     */
    public static final AdvancedNetworkPolicies L7 = fromString("L7");

    /**
     * Static value FQDN for AdvancedNetworkPolicies.
     */
    public static final AdvancedNetworkPolicies FQDN = fromString("FQDN");

    /**
     * Static value None for AdvancedNetworkPolicies.
     */
    public static final AdvancedNetworkPolicies NONE = fromString("None");

    /**
     * Creates a new instance of AdvancedNetworkPolicies value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AdvancedNetworkPolicies() {
    }

    /**
     * Creates or finds a AdvancedNetworkPolicies from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AdvancedNetworkPolicies.
     */
    public static AdvancedNetworkPolicies fromString(String name) {
        return fromString(name, AdvancedNetworkPolicies.class);
    }

    /**
     * Gets known AdvancedNetworkPolicies values.
     * 
     * @return known AdvancedNetworkPolicies values.
     */
    public static Collection<AdvancedNetworkPolicies> values() {
        return values(AdvancedNetworkPolicies.class);
    }
}
