// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * A time range. For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
 */
@Fluent
public final class TimeSpan implements JsonSerializable<TimeSpan> {
    /*
     * The start of a time span
     */
    private OffsetDateTime start;

    /*
     * The end of a time span
     */
    private OffsetDateTime end;

    /**
     * Creates an instance of TimeSpan class.
     */
    public TimeSpan() {
    }

    /**
     * Get the start property: The start of a time span.
     * 
     * @return the start value.
     */
    public OffsetDateTime start() {
        return this.start;
    }

    /**
     * Set the start property: The start of a time span.
     * 
     * @param start the start value to set.
     * @return the TimeSpan object itself.
     */
    public TimeSpan withStart(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The end of a time span.
     * 
     * @return the end value.
     */
    public OffsetDateTime end() {
        return this.end;
    }

    /**
     * Set the end property: The end of a time span.
     * 
     * @param end the end value to set.
     * @return the TimeSpan object itself.
     */
    public TimeSpan withEnd(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start",
            this.start == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.start));
        jsonWriter.writeStringField("end",
            this.end == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.end));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimeSpan from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimeSpan if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the TimeSpan.
     */
    public static TimeSpan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimeSpan deserializedTimeSpan = new TimeSpan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("start".equals(fieldName)) {
                    deserializedTimeSpan.start = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("end".equals(fieldName)) {
                    deserializedTimeSpan.end = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimeSpan;
        });
    }
}
