// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.SnapshotInner;
import java.io.IOException;
import java.util.List;

/**
 * The response from the List Snapshots operation.
 */
@Fluent
public final class SnapshotListResult implements JsonSerializable<SnapshotListResult> {
    /*
     * The list of snapshots.
     */
    private List<SnapshotInner> value;

    /*
     * The URL to get the next set of snapshot results.
     */
    private String nextLink;

    /**
     * Creates an instance of SnapshotListResult class.
     */
    public SnapshotListResult() {
    }

    /**
     * Get the value property: The list of snapshots.
     * 
     * @return the value value.
     */
    public List<SnapshotInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of snapshots.
     * 
     * @param value the value value to set.
     * @return the SnapshotListResult object itself.
     */
    public SnapshotListResult withValue(List<SnapshotInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of snapshot results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnapshotListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnapshotListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SnapshotListResult.
     */
    public static SnapshotListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotListResult deserializedSnapshotListResult = new SnapshotListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SnapshotInner> value = reader.readArray(reader1 -> SnapshotInner.fromJson(reader1));
                    deserializedSnapshotListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSnapshotListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSnapshotListResult;
        });
    }
}
