// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
 */
@Fluent
public final class RelativeMonthlySchedule implements JsonSerializable<RelativeMonthlySchedule> {
    /*
     * Specifies the number of months between each set of occurrences.
     */
    private int intervalMonths;

    /*
     * The week index. Specifies on which week of the month the dayOfWeek applies.
     */
    private Type weekIndex;

    /*
     * Specifies on which day of the week the maintenance occurs.
     */
    private WeekDay dayOfWeek;

    /**
     * Creates an instance of RelativeMonthlySchedule class.
     */
    public RelativeMonthlySchedule() {
    }

    /**
     * Get the intervalMonths property: Specifies the number of months between each set of occurrences.
     * 
     * @return the intervalMonths value.
     */
    public int intervalMonths() {
        return this.intervalMonths;
    }

    /**
     * Set the intervalMonths property: Specifies the number of months between each set of occurrences.
     * 
     * @param intervalMonths the intervalMonths value to set.
     * @return the RelativeMonthlySchedule object itself.
     */
    public RelativeMonthlySchedule withIntervalMonths(int intervalMonths) {
        this.intervalMonths = intervalMonths;
        return this;
    }

    /**
     * Get the weekIndex property: The week index. Specifies on which week of the month the dayOfWeek applies.
     * 
     * @return the weekIndex value.
     */
    public Type weekIndex() {
        return this.weekIndex;
    }

    /**
     * Set the weekIndex property: The week index. Specifies on which week of the month the dayOfWeek applies.
     * 
     * @param weekIndex the weekIndex value to set.
     * @return the RelativeMonthlySchedule object itself.
     */
    public RelativeMonthlySchedule withWeekIndex(Type weekIndex) {
        this.weekIndex = weekIndex;
        return this;
    }

    /**
     * Get the dayOfWeek property: Specifies on which day of the week the maintenance occurs.
     * 
     * @return the dayOfWeek value.
     */
    public WeekDay dayOfWeek() {
        return this.dayOfWeek;
    }

    /**
     * Set the dayOfWeek property: Specifies on which day of the week the maintenance occurs.
     * 
     * @param dayOfWeek the dayOfWeek value to set.
     * @return the RelativeMonthlySchedule object itself.
     */
    public RelativeMonthlySchedule withDayOfWeek(WeekDay dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (weekIndex() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property weekIndex in model RelativeMonthlySchedule"));
        }
        if (dayOfWeek() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property dayOfWeek in model RelativeMonthlySchedule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RelativeMonthlySchedule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("intervalMonths", this.intervalMonths);
        jsonWriter.writeStringField("weekIndex", this.weekIndex == null ? null : this.weekIndex.toString());
        jsonWriter.writeStringField("dayOfWeek", this.dayOfWeek == null ? null : this.dayOfWeek.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RelativeMonthlySchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RelativeMonthlySchedule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RelativeMonthlySchedule.
     */
    public static RelativeMonthlySchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RelativeMonthlySchedule deserializedRelativeMonthlySchedule = new RelativeMonthlySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("intervalMonths".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.intervalMonths = reader.getInt();
                } else if ("weekIndex".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.weekIndex = Type.fromString(reader.getString());
                } else if ("dayOfWeek".equals(fieldName)) {
                    deserializedRelativeMonthlySchedule.dayOfWeek = WeekDay.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRelativeMonthlySchedule;
        });
    }
}
