// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The port range.
 */
@Fluent
public final class PortRange implements JsonSerializable<PortRange> {
    /*
     * The minimum port that is included in the range. It should be ranged from 1 to 65535, and be less than or equal to
     * portEnd.
     */
    private Integer portStart;

    /*
     * The maximum port that is included in the range. It should be ranged from 1 to 65535, and be greater than or equal
     * to portStart.
     */
    private Integer portEnd;

    /*
     * The network protocol of the port.
     */
    private Protocol protocol;

    /**
     * Creates an instance of PortRange class.
     */
    public PortRange() {
    }

    /**
     * Get the portStart property: The minimum port that is included in the range. It should be ranged from 1 to 65535,
     * and be less than or equal to portEnd.
     * 
     * @return the portStart value.
     */
    public Integer portStart() {
        return this.portStart;
    }

    /**
     * Set the portStart property: The minimum port that is included in the range. It should be ranged from 1 to 65535,
     * and be less than or equal to portEnd.
     * 
     * @param portStart the portStart value to set.
     * @return the PortRange object itself.
     */
    public PortRange withPortStart(Integer portStart) {
        this.portStart = portStart;
        return this;
    }

    /**
     * Get the portEnd property: The maximum port that is included in the range. It should be ranged from 1 to 65535,
     * and be greater than or equal to portStart.
     * 
     * @return the portEnd value.
     */
    public Integer portEnd() {
        return this.portEnd;
    }

    /**
     * Set the portEnd property: The maximum port that is included in the range. It should be ranged from 1 to 65535,
     * and be greater than or equal to portStart.
     * 
     * @param portEnd the portEnd value to set.
     * @return the PortRange object itself.
     */
    public PortRange withPortEnd(Integer portEnd) {
        this.portEnd = portEnd;
        return this;
    }

    /**
     * Get the protocol property: The network protocol of the port.
     * 
     * @return the protocol value.
     */
    public Protocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The network protocol of the port.
     * 
     * @param protocol the protocol value to set.
     * @return the PortRange object itself.
     */
    public PortRange withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("portStart", this.portStart);
        jsonWriter.writeNumberField("portEnd", this.portEnd);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PortRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PortRange if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the PortRange.
     */
    public static PortRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PortRange deserializedPortRange = new PortRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("portStart".equals(fieldName)) {
                    deserializedPortRange.portStart = reader.getNullable(JsonReader::getInt);
                } else if ("portEnd".equals(fieldName)) {
                    deserializedPortRange.portEnd = reader.getNullable(JsonReader::getInt);
                } else if ("protocol".equals(fieldName)) {
                    deserializedPortRange.protocol = Protocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPortRange;
        });
    }
}
