// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The profile of an orchestrator and its available versions.
 */
@Fluent
public final class OrchestratorVersionProfile implements JsonSerializable<OrchestratorVersionProfile> {
    /*
     * Orchestrator type.
     */
    private String orchestratorType;

    /*
     * Orchestrator version (major, minor, patch).
     */
    private String orchestratorVersion;

    /*
     * Installed by default if version is not specified.
     */
    private Boolean defaultProperty;

    /*
     * Whether Kubernetes version is currently in preview.
     */
    private Boolean isPreview;

    /*
     * The list of available upgrade versions.
     */
    private List<OrchestratorProfile> upgrades;

    /**
     * Creates an instance of OrchestratorVersionProfile class.
     */
    public OrchestratorVersionProfile() {
    }

    /**
     * Get the orchestratorType property: Orchestrator type.
     * 
     * @return the orchestratorType value.
     */
    public String orchestratorType() {
        return this.orchestratorType;
    }

    /**
     * Set the orchestratorType property: Orchestrator type.
     * 
     * @param orchestratorType the orchestratorType value to set.
     * @return the OrchestratorVersionProfile object itself.
     */
    public OrchestratorVersionProfile withOrchestratorType(String orchestratorType) {
        this.orchestratorType = orchestratorType;
        return this;
    }

    /**
     * Get the orchestratorVersion property: Orchestrator version (major, minor, patch).
     * 
     * @return the orchestratorVersion value.
     */
    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    /**
     * Set the orchestratorVersion property: Orchestrator version (major, minor, patch).
     * 
     * @param orchestratorVersion the orchestratorVersion value to set.
     * @return the OrchestratorVersionProfile object itself.
     */
    public OrchestratorVersionProfile withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    /**
     * Get the defaultProperty property: Installed by default if version is not specified.
     * 
     * @return the defaultProperty value.
     */
    public Boolean defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: Installed by default if version is not specified.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the OrchestratorVersionProfile object itself.
     */
    public OrchestratorVersionProfile withDefaultProperty(Boolean defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Get the isPreview property: Whether Kubernetes version is currently in preview.
     * 
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Set the isPreview property: Whether Kubernetes version is currently in preview.
     * 
     * @param isPreview the isPreview value to set.
     * @return the OrchestratorVersionProfile object itself.
     */
    public OrchestratorVersionProfile withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    /**
     * Get the upgrades property: The list of available upgrade versions.
     * 
     * @return the upgrades value.
     */
    public List<OrchestratorProfile> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: The list of available upgrade versions.
     * 
     * @param upgrades the upgrades value to set.
     * @return the OrchestratorVersionProfile object itself.
     */
    public OrchestratorVersionProfile withUpgrades(List<OrchestratorProfile> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (orchestratorType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property orchestratorType in model OrchestratorVersionProfile"));
        }
        if (orchestratorVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property orchestratorVersion in model OrchestratorVersionProfile"));
        }
        if (upgrades() != null) {
            upgrades().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorVersionProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("orchestratorType", this.orchestratorType);
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion);
        jsonWriter.writeBooleanField("default", this.defaultProperty);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrchestratorVersionProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrchestratorVersionProfile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OrchestratorVersionProfile.
     */
    public static OrchestratorVersionProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestratorVersionProfile deserializedOrchestratorVersionProfile = new OrchestratorVersionProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("orchestratorType".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.orchestratorType = reader.getString();
                } else if ("orchestratorVersion".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.orchestratorVersion = reader.getString();
                } else if ("default".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.defaultProperty = reader.getNullable(JsonReader::getBoolean);
                } else if ("isPreview".equals(fieldName)) {
                    deserializedOrchestratorVersionProfile.isPreview = reader.getNullable(JsonReader::getBoolean);
                } else if ("upgrades".equals(fieldName)) {
                    List<OrchestratorProfile> upgrades
                        = reader.readArray(reader1 -> OrchestratorProfile.fromJson(reader1));
                    deserializedOrchestratorVersionProfile.upgrades = upgrades;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrchestratorVersionProfile;
        });
    }
}
