// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an OpenShift router.
 */
@Fluent
public final class OpenShiftRouterProfile implements JsonSerializable<OpenShiftRouterProfile> {
    /*
     * Name of the router profile.
     */
    private String name;

    /*
     * DNS subdomain for OpenShift router.
     */
    private String publicSubdomain;

    /*
     * Auto-allocated FQDN for the OpenShift router.
     */
    private String fqdn;

    /**
     * Creates an instance of OpenShiftRouterProfile class.
     */
    public OpenShiftRouterProfile() {
    }

    /**
     * Get the name property: Name of the router profile.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the router profile.
     * 
     * @param name the name value to set.
     * @return the OpenShiftRouterProfile object itself.
     */
    public OpenShiftRouterProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publicSubdomain property: DNS subdomain for OpenShift router.
     * 
     * @return the publicSubdomain value.
     */
    public String publicSubdomain() {
        return this.publicSubdomain;
    }

    /**
     * Get the fqdn property: Auto-allocated FQDN for the OpenShift router.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenShiftRouterProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenShiftRouterProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenShiftRouterProfile.
     */
    public static OpenShiftRouterProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenShiftRouterProfile deserializedOpenShiftRouterProfile = new OpenShiftRouterProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOpenShiftRouterProfile.name = reader.getString();
                } else if ("publicSubdomain".equals(fieldName)) {
                    deserializedOpenShiftRouterProfile.publicSubdomain = reader.getString();
                } else if ("fqdn".equals(fieldName)) {
                    deserializedOpenShiftRouterProfile.fqdn = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenShiftRouterProfile;
        });
    }
}
