// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the configuration of the identity providers to be used in the OpenShift cluster.
 */
@Fluent
public final class OpenShiftManagedClusterIdentityProvider
    implements JsonSerializable<OpenShiftManagedClusterIdentityProvider> {
    /*
     * Name of the provider.
     */
    private String name;

    /*
     * Configuration of the provider.
     */
    private OpenShiftManagedClusterBaseIdentityProvider provider;

    /**
     * Creates an instance of OpenShiftManagedClusterIdentityProvider class.
     */
    public OpenShiftManagedClusterIdentityProvider() {
    }

    /**
     * Get the name property: Name of the provider.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the provider.
     * 
     * @param name the name value to set.
     * @return the OpenShiftManagedClusterIdentityProvider object itself.
     */
    public OpenShiftManagedClusterIdentityProvider withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the provider property: Configuration of the provider.
     * 
     * @return the provider value.
     */
    public OpenShiftManagedClusterBaseIdentityProvider provider() {
        return this.provider;
    }

    /**
     * Set the provider property: Configuration of the provider.
     * 
     * @param provider the provider value to set.
     * @return the OpenShiftManagedClusterIdentityProvider object itself.
     */
    public OpenShiftManagedClusterIdentityProvider withProvider(OpenShiftManagedClusterBaseIdentityProvider provider) {
        this.provider = provider;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (provider() != null) {
            provider().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("provider", this.provider);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenShiftManagedClusterIdentityProvider from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenShiftManagedClusterIdentityProvider if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenShiftManagedClusterIdentityProvider.
     */
    public static OpenShiftManagedClusterIdentityProvider fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenShiftManagedClusterIdentityProvider deserializedOpenShiftManagedClusterIdentityProvider
                = new OpenShiftManagedClusterIdentityProvider();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterIdentityProvider.name = reader.getString();
                } else if ("provider".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterIdentityProvider.provider
                        = OpenShiftManagedClusterBaseIdentityProvider.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenShiftManagedClusterIdentityProvider;
        });
    }
}
