// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Mesh revision profile properties for a mesh.
 */
@Fluent
public final class MeshRevisionProfileProperties implements JsonSerializable<MeshRevisionProfileProperties> {
    /*
     * The meshRevisions property.
     */
    private List<MeshRevision> meshRevisions;

    /**
     * Creates an instance of MeshRevisionProfileProperties class.
     */
    public MeshRevisionProfileProperties() {
    }

    /**
     * Get the meshRevisions property: The meshRevisions property.
     * 
     * @return the meshRevisions value.
     */
    public List<MeshRevision> meshRevisions() {
        return this.meshRevisions;
    }

    /**
     * Set the meshRevisions property: The meshRevisions property.
     * 
     * @param meshRevisions the meshRevisions value to set.
     * @return the MeshRevisionProfileProperties object itself.
     */
    public MeshRevisionProfileProperties withMeshRevisions(List<MeshRevision> meshRevisions) {
        this.meshRevisions = meshRevisions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (meshRevisions() != null) {
            meshRevisions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("meshRevisions", this.meshRevisions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MeshRevisionProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MeshRevisionProfileProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MeshRevisionProfileProperties.
     */
    public static MeshRevisionProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MeshRevisionProfileProperties deserializedMeshRevisionProfileProperties
                = new MeshRevisionProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("meshRevisions".equals(fieldName)) {
                    List<MeshRevision> meshRevisions = reader.readArray(reader1 -> MeshRevision.fromJson(reader1));
                    deserializedMeshRevisionProfileProperties.meshRevisions = meshRevisions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMeshRevisionProfileProperties;
        });
    }
}
