// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Holds information on upgrades and compatibility for given major.minor mesh release.
 */
@Fluent
public class MeshRevision implements JsonSerializable<MeshRevision> {
    /*
     * The revision of the mesh release.
     */
    private String revision;

    /*
     * List of revisions available for upgrade of a specific mesh revision
     */
    private List<String> upgrades;

    /*
     * List of items this revision of service mesh is compatible with, and their associated versions.
     */
    private List<CompatibleVersions> compatibleWith;

    /**
     * Creates an instance of MeshRevision class.
     */
    public MeshRevision() {
    }

    /**
     * Get the revision property: The revision of the mesh release.
     * 
     * @return the revision value.
     */
    public String revision() {
        return this.revision;
    }

    /**
     * Set the revision property: The revision of the mesh release.
     * 
     * @param revision the revision value to set.
     * @return the MeshRevision object itself.
     */
    public MeshRevision withRevision(String revision) {
        this.revision = revision;
        return this;
    }

    /**
     * Get the upgrades property: List of revisions available for upgrade of a specific mesh revision.
     * 
     * @return the upgrades value.
     */
    public List<String> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: List of revisions available for upgrade of a specific mesh revision.
     * 
     * @param upgrades the upgrades value to set.
     * @return the MeshRevision object itself.
     */
    public MeshRevision withUpgrades(List<String> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Get the compatibleWith property: List of items this revision of service mesh is compatible with, and their
     * associated versions.
     * 
     * @return the compatibleWith value.
     */
    public List<CompatibleVersions> compatibleWith() {
        return this.compatibleWith;
    }

    /**
     * Set the compatibleWith property: List of items this revision of service mesh is compatible with, and their
     * associated versions.
     * 
     * @param compatibleWith the compatibleWith value to set.
     * @return the MeshRevision object itself.
     */
    public MeshRevision withCompatibleWith(List<CompatibleVersions> compatibleWith) {
        this.compatibleWith = compatibleWith;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (compatibleWith() != null) {
            compatibleWith().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revision", this.revision);
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("compatibleWith", this.compatibleWith,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MeshRevision from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MeshRevision if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MeshRevision.
     */
    public static MeshRevision fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MeshRevision deserializedMeshRevision = new MeshRevision();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("revision".equals(fieldName)) {
                    deserializedMeshRevision.revision = reader.getString();
                } else if ("upgrades".equals(fieldName)) {
                    List<String> upgrades = reader.readArray(reader1 -> reader1.getString());
                    deserializedMeshRevision.upgrades = upgrades;
                } else if ("compatibleWith".equals(fieldName)) {
                    List<CompatibleVersions> compatibleWith
                        = reader.readArray(reader1 -> CompatibleVersions.fromJson(reader1));
                    deserializedMeshRevision.compatibleWith = compatibleWith;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMeshRevision;
        });
    }
}
