// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Workload Auto-scaler profile for the managed cluster.
 */
@Fluent
public final class ManagedClusterWorkloadAutoScalerProfile
    implements JsonSerializable<ManagedClusterWorkloadAutoScalerProfile> {
    /*
     * KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     */
    private ManagedClusterWorkloadAutoScalerProfileKeda keda;

    /*
     * VPA (Vertical Pod Autoscaler) settings for the workload auto-scaler profile.
     */
    private ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler verticalPodAutoscaler;

    /**
     * Creates an instance of ManagedClusterWorkloadAutoScalerProfile class.
     */
    public ManagedClusterWorkloadAutoScalerProfile() {
    }

    /**
     * Get the keda property: KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     * 
     * @return the keda value.
     */
    public ManagedClusterWorkloadAutoScalerProfileKeda keda() {
        return this.keda;
    }

    /**
     * Set the keda property: KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     * 
     * @param keda the keda value to set.
     * @return the ManagedClusterWorkloadAutoScalerProfile object itself.
     */
    public ManagedClusterWorkloadAutoScalerProfile withKeda(ManagedClusterWorkloadAutoScalerProfileKeda keda) {
        this.keda = keda;
        return this;
    }

    /**
     * Get the verticalPodAutoscaler property: VPA (Vertical Pod Autoscaler) settings for the workload auto-scaler
     * profile.
     * 
     * @return the verticalPodAutoscaler value.
     */
    public ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler verticalPodAutoscaler() {
        return this.verticalPodAutoscaler;
    }

    /**
     * Set the verticalPodAutoscaler property: VPA (Vertical Pod Autoscaler) settings for the workload auto-scaler
     * profile.
     * 
     * @param verticalPodAutoscaler the verticalPodAutoscaler value to set.
     * @return the ManagedClusterWorkloadAutoScalerProfile object itself.
     */
    public ManagedClusterWorkloadAutoScalerProfile
        withVerticalPodAutoscaler(ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler verticalPodAutoscaler) {
        this.verticalPodAutoscaler = verticalPodAutoscaler;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keda() != null) {
            keda().validate();
        }
        if (verticalPodAutoscaler() != null) {
            verticalPodAutoscaler().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keda", this.keda);
        jsonWriter.writeJsonField("verticalPodAutoscaler", this.verticalPodAutoscaler);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterWorkloadAutoScalerProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterWorkloadAutoScalerProfile if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterWorkloadAutoScalerProfile.
     */
    public static ManagedClusterWorkloadAutoScalerProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterWorkloadAutoScalerProfile deserializedManagedClusterWorkloadAutoScalerProfile
                = new ManagedClusterWorkloadAutoScalerProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keda".equals(fieldName)) {
                    deserializedManagedClusterWorkloadAutoScalerProfile.keda
                        = ManagedClusterWorkloadAutoScalerProfileKeda.fromJson(reader);
                } else if ("verticalPodAutoscaler".equals(fieldName)) {
                    deserializedManagedClusterWorkloadAutoScalerProfile.verticalPodAutoscaler
                        = ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterWorkloadAutoScalerProfile;
        });
    }
}
