// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Desired outbound IP resources for the cluster load balancer.
 */
@Fluent
public final class ManagedClusterLoadBalancerProfileOutboundIPs
    implements JsonSerializable<ManagedClusterLoadBalancerProfileOutboundIPs> {
    /*
     * A list of public IP resources.
     */
    private List<ResourceReference> publicIPs;

    /**
     * Creates an instance of ManagedClusterLoadBalancerProfileOutboundIPs class.
     */
    public ManagedClusterLoadBalancerProfileOutboundIPs() {
    }

    /**
     * Get the publicIPs property: A list of public IP resources.
     * 
     * @return the publicIPs value.
     */
    public List<ResourceReference> publicIPs() {
        return this.publicIPs;
    }

    /**
     * Set the publicIPs property: A list of public IP resources.
     * 
     * @param publicIPs the publicIPs value to set.
     * @return the ManagedClusterLoadBalancerProfileOutboundIPs object itself.
     */
    public ManagedClusterLoadBalancerProfileOutboundIPs withPublicIPs(List<ResourceReference> publicIPs) {
        this.publicIPs = publicIPs;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publicIPs() != null) {
            publicIPs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("publicIPs", this.publicIPs, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterLoadBalancerProfileOutboundIPs from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterLoadBalancerProfileOutboundIPs if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterLoadBalancerProfileOutboundIPs.
     */
    public static ManagedClusterLoadBalancerProfileOutboundIPs fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterLoadBalancerProfileOutboundIPs deserializedManagedClusterLoadBalancerProfileOutboundIPs
                = new ManagedClusterLoadBalancerProfileOutboundIPs();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("publicIPs".equals(fieldName)) {
                    List<ResourceReference> publicIPs
                        = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedManagedClusterLoadBalancerProfileOutboundIPs.publicIPs = publicIPs;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterLoadBalancerProfileOutboundIPs;
        });
    }
}
