// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Identity for the managed cluster.
 */
@Fluent
public final class ManagedClusterIdentity implements JsonSerializable<ManagedClusterIdentity> {
    /*
     * The principal id of the system assigned identity which is used by master components.
     */
    private String principalId;

    /*
     * The tenant id of the system assigned identity which is used by master components.
     */
    private String tenantId;

    /*
     * The type of identity used for the managed cluster. For more information see [use managed identities in
     * AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
     */
    private ResourceIdentityType type;

    /*
     * The delegated identity resources assigned to this managed cluster. This can only be set by another Azure Resource
     * Provider, and managed cluster only accept one delegated identity resource. Internal use only.
     */
    private Map<String, DelegatedResource> delegatedResources;

    /*
     * The user identity associated with the managed cluster. This identity will be used in control plane. Only one user
     * assigned identity is allowed. The keys must be ARM resource IDs in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/
     * userAssignedIdentities/{identityName}'.
     */
    private Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    /**
     * Creates an instance of ManagedClusterIdentity class.
     */
    public ManagedClusterIdentity() {
    }

    /**
     * Get the principalId property: The principal id of the system assigned identity which is used by master
     * components.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The tenant id of the system assigned identity which is used by master components.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of identity used for the managed cluster. For more information see [use managed
     * identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
     * 
     * @return the type value.
     */
    public ResourceIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the managed cluster. For more information see [use managed
     * identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
     * 
     * @param type the type value to set.
     * @return the ManagedClusterIdentity object itself.
     */
    public ManagedClusterIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the delegatedResources property: The delegated identity resources assigned to this managed cluster. This can
     * only be set by another Azure Resource Provider, and managed cluster only accept one delegated identity resource.
     * Internal use only.
     * 
     * @return the delegatedResources value.
     */
    public Map<String, DelegatedResource> delegatedResources() {
        return this.delegatedResources;
    }

    /**
     * Set the delegatedResources property: The delegated identity resources assigned to this managed cluster. This can
     * only be set by another Azure Resource Provider, and managed cluster only accept one delegated identity resource.
     * Internal use only.
     * 
     * @param delegatedResources the delegatedResources value to set.
     * @return the ManagedClusterIdentity object itself.
     */
    public ManagedClusterIdentity withDelegatedResources(Map<String, DelegatedResource> delegatedResources) {
        this.delegatedResources = delegatedResources;
        return this;
    }

    /**
     * Get the userAssignedIdentities property: The user identity associated with the managed cluster. This identity
     * will be used in control plane. Only one user assigned identity is allowed. The keys must be ARM resource IDs in
     * the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The user identity associated with the managed cluster. This identity
     * will be used in control plane. Only one user assigned identity is allowed. The keys must be ARM resource IDs in
     * the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the ManagedClusterIdentity object itself.
     */
    public ManagedClusterIdentity withUserAssignedIdentities(
        Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (delegatedResources() != null) {
            delegatedResources().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("delegatedResources", this.delegatedResources,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterIdentity if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterIdentity.
     */
    public static ManagedClusterIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterIdentity deserializedManagedClusterIdentity = new ManagedClusterIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedManagedClusterIdentity.principalId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedManagedClusterIdentity.tenantId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedClusterIdentity.type = ResourceIdentityType.fromString(reader.getString());
                } else if ("delegatedResources".equals(fieldName)) {
                    Map<String, DelegatedResource> delegatedResources
                        = reader.readMap(reader1 -> DelegatedResource.fromJson(reader1));
                    deserializedManagedClusterIdentity.delegatedResources = delegatedResources;
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities = reader
                        .readMap(reader1 -> ManagedServiceIdentityUserAssignedIdentitiesValue.fromJson(reader1));
                    deserializedManagedClusterIdentity.userAssignedIdentities = userAssignedIdentities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterIdentity;
        });
    }
}
