// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A Kubernetes add-on profile for a managed cluster.
 */
@Fluent
public final class ManagedClusterAddonProfile implements JsonSerializable<ManagedClusterAddonProfile> {
    /*
     * Whether the add-on is enabled or not.
     */
    private boolean enabled;

    /*
     * Key-value pairs for configuring an add-on.
     */
    private Map<String, String> config;

    /*
     * Information of user assigned identity used by this add-on.
     */
    private ManagedClusterAddonProfileIdentity identity;

    /**
     * Creates an instance of ManagedClusterAddonProfile class.
     */
    public ManagedClusterAddonProfile() {
    }

    /**
     * Get the enabled property: Whether the add-on is enabled or not.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether the add-on is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterAddonProfile object itself.
     */
    public ManagedClusterAddonProfile withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the config property: Key-value pairs for configuring an add-on.
     * 
     * @return the config value.
     */
    public Map<String, String> config() {
        return this.config;
    }

    /**
     * Set the config property: Key-value pairs for configuring an add-on.
     * 
     * @param config the config value to set.
     * @return the ManagedClusterAddonProfile object itself.
     */
    public ManagedClusterAddonProfile withConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    /**
     * Get the identity property: Information of user assigned identity used by this add-on.
     * 
     * @return the identity value.
     */
    public ManagedClusterAddonProfileIdentity identity() {
        return this.identity;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeMapField("config", this.config, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterAddonProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterAddonProfile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterAddonProfile.
     */
    public static ManagedClusterAddonProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterAddonProfile deserializedManagedClusterAddonProfile = new ManagedClusterAddonProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterAddonProfile.enabled = reader.getBoolean();
                } else if ("config".equals(fieldName)) {
                    Map<String, String> config = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAddonProfile.config = config;
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedClusterAddonProfile.identity
                        = ManagedClusterAddonProfileIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterAddonProfile;
        });
    }
}
