// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * When enabling the operator, a set of AKS managed CRDs and controllers will be installed in the cluster. The operator
 * automates the deployment of OSS models for inference and/or training purposes. It provides a set of preset models and
 * enables distributed inference against them.
 */
@Fluent
public final class ManagedClusterAIToolchainOperatorProfile
    implements JsonSerializable<ManagedClusterAIToolchainOperatorProfile> {
    /*
     * Whether to enable AI toolchain operator to the cluster. Indicates if AI toolchain operator enabled or not.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedClusterAIToolchainOperatorProfile class.
     */
    public ManagedClusterAIToolchainOperatorProfile() {
    }

    /**
     * Get the enabled property: Whether to enable AI toolchain operator to the cluster. Indicates if AI toolchain
     * operator enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable AI toolchain operator to the cluster. Indicates if AI toolchain
     * operator enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterAIToolchainOperatorProfile object itself.
     */
    public ManagedClusterAIToolchainOperatorProfile withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterAIToolchainOperatorProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterAIToolchainOperatorProfile if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterAIToolchainOperatorProfile.
     */
    public static ManagedClusterAIToolchainOperatorProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterAIToolchainOperatorProfile deserializedManagedClusterAIToolchainOperatorProfile
                = new ManagedClusterAIToolchainOperatorProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterAIToolchainOperatorProfile.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterAIToolchainOperatorProfile;
        });
    }
}
