// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Capabilities on this Kubernetes version.
 */
@Fluent
public final class KubernetesVersionCapabilities implements JsonSerializable<KubernetesVersionCapabilities> {
    /*
     * The supportPlan property.
     */
    private List<KubernetesSupportPlan> supportPlan;

    /**
     * Creates an instance of KubernetesVersionCapabilities class.
     */
    public KubernetesVersionCapabilities() {
    }

    /**
     * Get the supportPlan property: The supportPlan property.
     * 
     * @return the supportPlan value.
     */
    public List<KubernetesSupportPlan> supportPlan() {
        return this.supportPlan;
    }

    /**
     * Set the supportPlan property: The supportPlan property.
     * 
     * @param supportPlan the supportPlan value to set.
     * @return the KubernetesVersionCapabilities object itself.
     */
    public KubernetesVersionCapabilities withSupportPlan(List<KubernetesSupportPlan> supportPlan) {
        this.supportPlan = supportPlan;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("supportPlan", this.supportPlan,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KubernetesVersionCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KubernetesVersionCapabilities if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KubernetesVersionCapabilities.
     */
    public static KubernetesVersionCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubernetesVersionCapabilities deserializedKubernetesVersionCapabilities
                = new KubernetesVersionCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("supportPlan".equals(fieldName)) {
                    List<KubernetesSupportPlan> supportPlan
                        = reader.readArray(reader1 -> KubernetesSupportPlan.fromString(reader1.getString()));
                    deserializedKubernetesVersionCapabilities.supportPlan = supportPlan;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKubernetesVersionCapabilities;
        });
    }
}
