// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Different support tiers for AKS managed clusters.
 */
public final class KubernetesSupportPlan extends ExpandableStringEnum<KubernetesSupportPlan> {
    /**
     * Static value KubernetesOfficial for KubernetesSupportPlan.
     */
    public static final KubernetesSupportPlan KUBERNETES_OFFICIAL = fromString("KubernetesOfficial");

    /**
     * Static value AKSLongTermSupport for KubernetesSupportPlan.
     */
    public static final KubernetesSupportPlan AKSLONG_TERM_SUPPORT = fromString("AKSLongTermSupport");

    /**
     * Creates a new instance of KubernetesSupportPlan value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public KubernetesSupportPlan() {
    }

    /**
     * Creates or finds a KubernetesSupportPlan from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KubernetesSupportPlan.
     */
    public static KubernetesSupportPlan fromString(String name) {
        return fromString(name, KubernetesSupportPlan.class);
    }

    /**
     * Gets known KubernetesSupportPlan values.
     * 
     * @return known KubernetesSupportPlan values.
     */
    public static Collection<KubernetesSupportPlan> values() {
        return values(KubernetesSupportPlan.class);
    }
}
